/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;
import numpy.core.FunctionUtil;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.python.AbstractTranslator;
import org.jpmml.python.ExpressionTranslatorConstants;
import org.jpmml.python.ExpressionTranslatorTokenManager;
import org.jpmml.python.ExpressionUtil;
import org.jpmml.python.ParseException;
import org.jpmml.python.Provider;
import org.jpmml.python.Scope;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import org.jpmml.python.TokenMgrException;

public class ExpressionTranslator
extends AbstractTranslator
implements ExpressionTranslatorConstants {
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[34];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public static Expression translate(String string, Scope scope) {
        return ExpressionTranslator.translate(string, scope, true);
    }

    public static Expression translate(String string, Scope scope, boolean compact) {
        Expression expression;
        try {
            ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
            expressionTranslator.setScope(scope);
            expression = expressionTranslator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python expression '" + string + "' is either invalid or not supported", pe);
        }
        if (compact) {
            ExpressionCompactor compactor = new ExpressionCompactor();
            compactor.applyTo((Visitable)expression);
        }
        return expression;
    }

    private static String translateRelationalOperator(Token operator) {
        switch (operator.kind) {
            case 12: {
                return "equal";
            }
            case 13: {
                return "notEqual";
            }
            case 14: {
                return "lessThan";
            }
            case 15: {
                return "lessOrEqual";
            }
            case 16: {
                return "greaterThan";
            }
            case 17: {
                return "greaterOrEqual";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateArithmeticOperator(Token operator) {
        switch (operator.kind) {
            case 22: {
                return "modulo";
            }
        }
        return operator.image;
    }

    private static Constant translateConstant(String module, Token value) {
        if ("numpy".equals(module) || "np".equals(module)) {
            switch (value.kind) {
                case 32: {
                    return PMMLUtil.createMissingConstant();
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(module);
    }

    private static Expression translateTrailerFunction(Expression expression, String function, List<Expression> arguments) {
        if ("startswith".equals(function) || "endswith".equals(function)) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException();
            }
            Expression argument = arguments.get(0);
            if (!(argument instanceof Constant)) {
                throw new IllegalArgumentException();
            }
            Constant constant = (Constant)argument;
            if (constant.getDataType() != DataType.STRING) {
                throw new IllegalArgumentException();
            }
            String value = (String)constant.getValue();
            switch (function) {
                case "startswith": {
                    return PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{ExpressionTranslator.translateStringSlice(expression, 0, value.length()), constant});
                }
                case "endswith": {
                    return PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{ExpressionTranslator.translateStringSlice(expression, -value.length(), null), constant});
                }
            }
        } else if ("lower".equals(function) || "upper".equals(function)) {
            if (arguments.size() != 0) {
                throw new IllegalArgumentException();
            }
            switch (function) {
                case "lower": {
                    return PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{expression});
                }
                case "upper": {
                    return PMMLUtil.createApply((String)"uppercase", (Expression[])new Expression[]{expression});
                }
            }
        } else if ("strip".equals(function)) {
            if (arguments.size() != 0) {
                throw new IllegalArgumentException();
            }
            return PMMLUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{expression});
        }
        throw new IllegalArgumentException(function);
    }

    private static Expression translateFunction(String function, List<Expression> arguments) {
        String name;
        String module;
        int dot = function.lastIndexOf(46);
        if (dot > -1) {
            module = function.substring(0, dot);
            name = function.substring(dot + 1);
        } else {
            module = "";
            name = function;
        }
        if ("".equals(module)) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException();
            }
            switch (name) {
                case "len": {
                    return PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{arguments.get(0)});
                }
            }
        } else if ("pandas".equals(module) || "pd".equals(module)) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException();
            }
            switch (name) {
                case "isnull": {
                    return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{arguments.get(0)});
                }
                case "notnull": {
                    return PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{arguments.get(0)});
                }
            }
        } else if ("numpy".equals(module) || "np".equals(module)) {
            return FunctionUtil.encodeFunction("numpy", name, arguments);
        }
        throw new IllegalArgumentException(function);
    }

    private static Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos) {
        if (startPos == null && stopPos == null) {
            return expression;
        }
        Object offsetExpression = startPos != null && startPos >= 0 ? PMMLUtil.createConstant((Object)(startPos + 1), (DataType)DataType.INTEGER) : (startPos != null && startPos < 0 ? PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Object)(-startPos.intValue() - 1), (DataType)DataType.INTEGER)}), PMMLUtil.createConstant((Object)1, (DataType)DataType.INTEGER)}) : PMMLUtil.createConstant((Object)1, (DataType)DataType.INTEGER));
        Object lengthExpression = stopPos != null && stopPos >= 0 ? (startPos != null && startPos >= 0 ? PMMLUtil.createConstant((Object)Math.max(stopPos - startPos, 0), (DataType)DataType.INTEGER) : (startPos != null && startPos < 0 ? PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER) : PMMLUtil.createConstant((Object)stopPos, (DataType)DataType.INTEGER))) : (stopPos != null && stopPos < 0 ? (startPos != null && startPos >= 0 ? PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Number)(startPos + -stopPos.intValue()))}), PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER)}) : (startPos != null && startPos < 0 ? PMMLUtil.createConstant((Object)Math.max(stopPos - startPos, 0), (DataType)DataType.INTEGER) : PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Number)(-stopPos.intValue()))}), PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER)}))) : PMMLUtil.createConstant((Object)Integer.MAX_VALUE, (DataType)DataType.INTEGER));
        return PMMLUtil.createApply((String)"substring", (Expression[])new Expression[]{expression, offsetExpression, lengthExpression});
    }

    private static Object translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 29: {
                return null;
            }
            case 30: 
            case 31: {
                return Boolean.valueOf(image.toLowerCase());
            }
            case 33: {
                if (image.endsWith("l") || image.endsWith("L")) {
                    image = image.substring(0, image.length() - 1);
                }
                return Integer.valueOf(image);
            }
            case 34: {
                return Double.valueOf(image);
            }
            case 36: {
                return image.substring(1, image.length() - 1);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int parseInt(Token sign, Token value) {
        return Integer.parseInt(sign != null ? sign.image + value.image : value.image);
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression = this.IfElseExpression();
        return expression;
    }

    public final Expression IfElseExpression() throws ParseException {
        Expression left = this.LogicalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                Expression center = this.Expression();
                this.jj_consume_token(6);
                Expression right = this.Expression();
                left = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{center, left, right});
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression LogicalOrExpression() throws ParseException {
        Expression left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Expression right = this.LogicalAndExpression();
            left = PMMLUtil.createApply((String)"or", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression LogicalAndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Expression right = this.NegationExpression();
            left = PMMLUtil.createApply((String)"and", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                operator = this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Expression expression = this.ComparisonExpression();
        if (operator != null) {
            return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{expression});
        }
        return expression;
    }

    public final Expression ComparisonExpression() throws ParseException {
        Expression left;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(10);
            this.jj_consume_token(29);
            left = PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{left});
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(10);
            this.jj_consume_token(9);
            this.jj_consume_token(29);
            left = PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{left});
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(11);
            Expression[] right = this.ListMakerExpression();
            left = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{left}).addExpressions(right);
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(9);
            this.jj_consume_token(11);
            Expression[] right = this.ListMakerExpression();
            left = PMMLUtil.createApply((String)"isNotIn", (Expression[])new Expression[]{left}).addExpressions(right);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 18: 
                case 19: 
                case 29: 
                case 30: 
                case 31: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    left = this.AdditiveExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            Token operator;
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 12: {
                                    operator = this.jj_consume_token(12);
                                    break;
                                }
                                case 13: {
                                    operator = this.jj_consume_token(13);
                                    break;
                                }
                                case 14: {
                                    operator = this.jj_consume_token(14);
                                    break;
                                }
                                case 15: {
                                    operator = this.jj_consume_token(15);
                                    break;
                                }
                                case 16: {
                                    operator = this.jj_consume_token(16);
                                    break;
                                }
                                case 17: {
                                    operator = this.jj_consume_token(17);
                                    break;
                                }
                                default: {
                                    this.jj_la1[4] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            Expression right = this.AdditiveExpression();
                            left = PMMLUtil.createApply((String)ExpressionTranslator.translateRelationalOperator(operator), (Expression[])new Expression[]{left, right});
                            break block0;
                        }
                    }
                    this.jj_la1[5] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return left;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    operator = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    operator = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            Scope scope = this.ensureScope();
            if (operator.kind == 18 && ExpressionUtil.isString(left, scope) && ExpressionUtil.isString(right, scope)) {
                left = PMMLUtil.createApply((String)"concat", (Expression[])new Expression[]{left, right});
                continue;
            }
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block8: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: {
                    operator = this.jj_consume_token(20);
                    break;
                }
                case 21: {
                    operator = this.jj_consume_token(21);
                    break;
                }
                case 22: {
                    operator = this.jj_consume_token(22);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression expression;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                sign = this.jj_consume_token(18);
                expression = this.UnaryExpression();
                break;
            }
            case 19: {
                sign = this.jj_consume_token(19);
                expression = this.UnaryExpression();
                break;
            }
            case 3: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                expression = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 19) {
            expression = PMMLUtil.toNegative((Expression)expression);
        }
        return expression;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                String featureOrFunction = this.DottedName();
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    expression = this.ArrayIndexingExpression(featureOrFunction);
                    block40: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: 
                            case 27: {
                                break;
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                                break block0;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 27: {
                                expression = this.TrailerFunctionInvocationExpression(expression);
                                continue block40;
                            }
                            case 24: {
                                expression = this.StringSlicingExpression(expression);
                                continue block40;
                            }
                        }
                        break;
                    }
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        expression = this.FunctionInvocationExpression(featureOrFunction);
                        block41: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 24: 
                                case 27: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[14] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 27: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block41;
                                }
                                case 24: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block41;
                                }
                            }
                            break;
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 27: {
                        expression = this.ConstantExpression(featureOrFunction);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                expression = this.NameInvocationExpression(featureOrFunction);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        expression = this.StringSlicingExpression(expression);
                        block42: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 24: 
                                case 27: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[16] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 27: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block42;
                                }
                                case 24: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block42;
                                }
                            }
                            break;
                        }
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            case 3: {
                expression = this.ParenthesizedExpression();
                block43: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 24: 
                        case 27: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 27: {
                            expression = this.TrailerFunctionInvocationExpression(expression);
                            continue block43;
                        }
                        case 24: {
                            expression = this.StringSlicingExpression(expression);
                            continue block43;
                        }
                    }
                    break;
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: {
                expression = this.LiteralExpression();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final String DottedName() throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token name = this.jj_consume_token(35);
        sb.append(name.image);
        while (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(27);
            name = this.jj_consume_token(35);
            sb.append('.').append(name.image);
        }
        return sb.toString();
    }

    public final FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {
        Token column;
        Token sign = null;
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(24);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: {
                    sign = this.Sign();
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            column = this.jj_consume_token(33);
            this.jj_consume_token(25);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.jj_consume_token(24);
                    column = this.jj_consume_token(36);
                    this.jj_consume_token(25);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        Scope scope = this.ensureScope();
        Feature feature = null;
        switch (column.kind) {
            case 33: {
                int colIndex = ExpressionTranslator.parseInt(sign, column);
                feature = scope.getFeature(dottedName, colIndex);
                break;
            }
            case 36: {
                String colName = column.image.substring(1, column.image.length() - 1);
                feature = scope.getFeature(dottedName, colName);
                break;
            }
        }
        return feature.ref();
    }

    public final Token Sign() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final Expression FunctionInvocationExpression(String dottedName) throws ParseException {
        List<Expression> arguments = this.Arguments();
        Scope scope = this.ensureScope();
        int dot = dottedName.lastIndexOf(46);
        if (dot > -1) {
            String featureName = dottedName.substring(0, dot);
            String functionName = dottedName.substring(dot + 1);
            Feature feature = scope.resolveFeature(featureName);
            if (feature != null) {
                return ExpressionTranslator.translateTrailerFunction((Expression)feature.ref(), functionName, arguments);
            }
        }
        return ExpressionTranslator.translateFunction(dottedName, arguments);
    }

    public final Expression TrailerFunctionInvocationExpression(Expression expression) throws ParseException {
        this.jj_consume_token(27);
        Token name = this.jj_consume_token(35);
        List<Expression> arguments = this.Arguments();
        return ExpressionTranslator.translateTrailerFunction(expression, name.image, arguments);
    }

    public final List<Expression> Arguments() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(3);
            this.jj_consume_token(4);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    Expression expression = this.Expression();
                    expressions.add(expression);
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 26: {
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(26);
                        expression = this.Expression();
                        expressions.add(expression);
                    }
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expressions;
    }

    public final Expression StringSlicingExpression(Expression expression) throws ParseException {
        Token startSign = null;
        Token start = null;
        Token stopSign = null;
        Token stop = null;
        this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 33: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 18: 
                    case 19: {
                        startSign = this.Sign();
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                    }
                }
                start = this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 33: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 18: 
                    case 19: {
                        stopSign = this.Sign();
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                stop = this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
        Integer startPos = null;
        if (start != null) {
            startPos = ExpressionTranslator.parseInt(startSign, start);
        }
        Integer stopPos = null;
        if (stop != null) {
            stopPos = ExpressionTranslator.parseInt(stopSign, stop);
        }
        return ExpressionTranslator.translateStringSlice(expression, startPos, stopPos);
    }

    public final Constant ConstantExpression(String dottedName) throws ParseException {
        this.jj_consume_token(27);
        Token value = this.jj_consume_token(32);
        return ExpressionTranslator.translateConstant(dottedName, value);
    }

    public final FieldRef NameInvocationExpression(String dottedName) throws ParseException {
        Scope scope = this.ensureScope();
        Feature feature = scope.getFeature(dottedName);
        return feature.ref();
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(3);
        Expression expression = this.Expression();
        this.jj_consume_token(4);
        return expression;
    }

    public final Constant LiteralExpression() throws ParseException {
        DataType dataType;
        Token value;
        Boolean missing = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                value = this.jj_consume_token(29);
                dataType = null;
                missing = Boolean.TRUE;
                break;
            }
            case 30: {
                value = this.jj_consume_token(30);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 31: {
                value = this.jj_consume_token(31);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 33: {
                value = this.jj_consume_token(33);
                dataType = DataType.INTEGER;
                break;
            }
            case 34: {
                value = this.jj_consume_token(34);
                dataType = DataType.DOUBLE;
                break;
            }
            case 36: {
                value = this.jj_consume_token(36);
                dataType = DataType.STRING;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue(ExpressionTranslator.translateValue(value)).setDataType(dataType).setMissing(missing);
        return constant;
    }

    public final Expression[] ListMakerExpression() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        this.jj_consume_token(24);
        Expression expression = this.Expression();
        expressions.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(26);
            expression = this.Expression();
            expressions.add(expression);
        }
        this.jj_consume_token(25);
        return expressions.toArray(new Expression[expressions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_FunctionInvocationExpression_752_9_40() {
        return this.jj_3R_Arguments_791_9_56();
    }

    private boolean jj_3R_LogicalOrExpression_522_41_75() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_LogicalAndExpression_535_9_74();
    }

    private boolean jj_3R_NegationExpression_548_9_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_ComparisonExpression_566_9_78();
    }

    private boolean jj_3R_PrimaryExpression_660_88_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_660_88_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_660_151_58()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_664_84_44() {
        Token xsp;
        if (this.jj_3R_StringSlicingExpression_811_9_59()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_664_135_60());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_660_88_57() {
        return this.jj_3R_TrailerFunctionInvocationExpression_778_9_62();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_Sign_736_9_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_658_83_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_658_83_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_658_146_55()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_658_83_54() {
        return this.jj_3R_TrailerFunctionInvocationExpression_778_9_62();
    }

    private boolean jj_3R_IfElseExpression_509_40_70() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_Expression_495_9_45()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Expression_495_9_45();
    }

    private boolean jj_3R_null_697_39_14() {
        return this.jj_3R_Sign_736_9_19();
    }

    private boolean jj_3R_LogicalAndExpression_535_9_74() {
        Token xsp;
        if (this.jj_3R_NegationExpression_548_9_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalAndExpression_535_39_77());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_DottedName_683_52_38() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_ArrayIndexingExpression_698_29_22() {
        return this.jj_3R_Sign_736_9_19();
    }

    private boolean jj_3R_PrimaryExpression_667_58_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_667_58_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_667_121_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_667_58_46() {
        return this.jj_3R_TrailerFunctionInvocationExpression_778_9_62();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_697_39_14()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_LogicalOrExpression_522_9_69() {
        Token xsp;
        if (this.jj_3R_LogicalAndExpression_535_9_74()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalOrExpression_522_41_75());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ListMakerExpression_902_9_84() {
        Token xsp;
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_3R_Expression_495_9_45()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ListMakerExpression_902_81_86());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_ArrayIndexingExpression_700_17_18() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_ArrayIndexingExpression_697_17_17() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_698_29_22()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_IfElseExpression_509_9_61() {
        if (this.jj_3R_LogicalOrExpression_522_9_69()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_IfElseExpression_509_40_70()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_LiteralExpression_883_17_53() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_LiteralExpression_881_17_52() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_ArrayIndexingExpression_696_9_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_697_17_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ArrayIndexingExpression_700_17_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_LiteralExpression_879_17_51() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_LiteralExpression_877_17_50() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_LiteralExpression_875_17_49() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_LiteralExpression_873_17_48() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_Expression_495_9_45() {
        return this.jj_3R_IfElseExpression_509_9_61();
    }

    private boolean jj_3R_DottedName_683_9_30() {
        Token xsp;
        if (this.jj_scan_token(35)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_DottedName_683_52_38());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_ArrayIndexingExpression_696_9_13();
    }

    private boolean jj_3R_Arguments_795_87_71() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_Expression_495_9_45();
    }

    private boolean jj_3R_LiteralExpression_872_9_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_LiteralExpression_873_17_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_LiteralExpression_875_17_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_LiteralExpression_877_17_50()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_LiteralExpression_879_17_51()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_LiteralExpression_881_17_52()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_LiteralExpression_883_17_53()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_664_25_34() {
        if (this.jj_3R_NameInvocationExpression_844_9_43()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_664_84_44()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_StringSlicingExpression_811_69_73() {
        return this.jj_3R_Sign_736_9_19();
    }

    private boolean jj_3R_StringSlicingExpression_811_68_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringSlicingExpression_811_69_73()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_PrimaryExpression_662_25_33() {
        return this.jj_3R_ConstantExpression_833_9_42();
    }

    private boolean jj_3R_PrimaryExpression_669_17_29() {
        return this.jj_3R_LiteralExpression_872_9_37();
    }

    private boolean jj_3R_PrimaryExpression_660_25_32() {
        Token xsp;
        if (this.jj_3R_FunctionInvocationExpression_752_9_40()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_660_88_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_667_17_28() {
        Token xsp;
        if (this.jj_3R_ParenthesizedExpression_858_9_35()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_667_58_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_657_25_31() {
        Token xsp;
        if (this.jj_3R_ArrayIndexingExpression_696_9_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_658_83_39());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ParenthesizedExpression_858_9_35() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Expression_495_9_45()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_PrimaryExpression_655_17_27() {
        if (this.jj_3R_DottedName_683_9_30()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_657_25_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_660_25_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_PrimaryExpression_662_25_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_PrimaryExpression_664_25_34()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_664_198_68() {
        return this.jj_3R_StringSlicingExpression_811_9_59();
    }

    private boolean jj_3R_PrimaryExpression_654_9_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_655_17_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_667_17_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_PrimaryExpression_669_17_29()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_NameInvocationExpression_844_9_43() {
        return false;
    }

    private boolean jj_3R_UnaryExpression_636_17_25() {
        return this.jj_3R_PrimaryExpression_654_9_26();
    }

    private boolean jj_3R_MultiplicativeExpression_618_35_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(21)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(22)) {
                    return true;
                }
            }
        }
        return this.jj_3R_UnaryExpression_631_9_20();
    }

    private boolean jj_3R_UnaryExpression_634_17_24() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_631_9_20();
    }

    private boolean jj_3R_ConstantExpression_833_9_42() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_UnaryExpression_632_17_23() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_631_9_20();
    }

    private boolean jj_3R_StringSlicingExpression_811_22_72() {
        return this.jj_3R_Sign_736_9_19();
    }

    private boolean jj_3R_StringSlicingExpression_811_21_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringSlicingExpression_811_22_72()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_UnaryExpression_631_9_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_UnaryExpression_632_17_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_UnaryExpression_634_17_24()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_UnaryExpression_636_17_25()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_AdditiveExpression_594_44_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return this.jj_3R_MultiplicativeExpression_618_9_15();
    }

    private boolean jj_3R_StringSlicingExpression_811_9_59() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringSlicingExpression_811_21_65()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_StringSlicingExpression_811_68_66()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MultiplicativeExpression_618_9_15() {
        Token xsp;
        if (this.jj_3R_UnaryExpression_631_9_20()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_MultiplicativeExpression_618_35_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ComparisonExpression_579_46_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_AdditiveExpression_594_9_12();
    }

    private boolean jj_3R_Arguments_795_17_64() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Expression_495_9_45()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_Arguments_795_87_71());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_PrimaryExpression_660_151_58() {
        return this.jj_3R_StringSlicingExpression_811_9_59();
    }

    private boolean jj_3R_Arguments_792_17_63() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_PrimaryExpression_658_146_55() {
        return this.jj_3R_StringSlicingExpression_811_9_59();
    }

    private boolean jj_3R_Arguments_791_9_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Arguments_792_17_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Arguments_795_17_64()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_664_135_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_664_135_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_664_198_68()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_664_135_67() {
        return this.jj_3R_TrailerFunctionInvocationExpression_778_9_62();
    }

    private boolean jj_3_4() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_AdditiveExpression_594_9_12() {
        Token xsp;
        if (this.jj_3R_MultiplicativeExpression_618_9_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_AdditiveExpression_594_44_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ListMakerExpression_902_81_86() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_Expression_495_9_45();
    }

    private boolean jj_3_3() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3_2() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_PrimaryExpression_667_121_47() {
        return this.jj_3R_StringSlicingExpression_811_9_59();
    }

    private boolean jj_3R_ComparisonExpression_579_17_83() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_579_46_85()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_TrailerFunctionInvocationExpression_778_9_62() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_Arguments_791_9_56();
    }

    private boolean jj_3_1() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_576_17_82() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_902_9_84();
    }

    private boolean jj_3R_ComparisonExpression_573_17_81() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_902_9_84();
    }

    private boolean jj_3R_ComparisonExpression_570_17_80() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_567_17_79() {
        if (this.jj_3R_AdditiveExpression_594_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_566_9_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_567_17_79()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ComparisonExpression_570_17_80()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_ComparisonExpression_573_17_81()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_ComparisonExpression_576_17_82()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_ComparisonExpression_579_17_83()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_LogicalAndExpression_535_39_77() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_NegationExpression_548_9_76();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 128, 256, 512, 258048, 258048, -536084472, 786432, 786432, 0x700000, 0x700000, -536084472, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x1000000, 0x8000008, 0x9000000, 0x9000000, -536870904, 786432, 0x1000000, 786432, 0x4000000, 8, 786432, 786432, 786432, 786432, -536870912, 0x4000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 2, 0, 2, 22, 0};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[41];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 34; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 41; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

