/*
 * Decompiled with CFR 0.152.
 */
package joblib;

import java.io.IOException;
import java.io.InputStream;
import numpy.DType;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.python.PythonObject;

public class NumpyArrayWrapper
extends PythonObject {
    public NumpyArrayWrapper(String module, String name) {
        super(module, name);
    }

    public NDArray toArray(InputStream is) throws IOException {
        DType dtype = this.getDType();
        Object[] shape = this.getShape();
        String order = this.getOrder();
        Integer numpyArrayAlignmentBytes = this.getNumpyArrayAlignmentBytes();
        Boolean fortranOrder = NumpyArrayWrapper.parseOrder(order);
        Object data = NDArrayUtil.parseData(is, dtype, shape, numpyArrayAlignmentBytes);
        NDArray array = new NDArray();
        array.__setstate__(new Object[]{null, shape, dtype, fortranOrder, data});
        return array;
    }

    public DType getDType() {
        return this.get("dtype", DType.class);
    }

    public Object[] getShape() {
        return this.getTuple("shape");
    }

    public String getOrder() {
        return this.getString("order");
    }

    public Integer getNumpyArrayAlignmentBytes() {
        if (!this.containsKey("numpy_array_alignment_bytes")) {
            return null;
        }
        return this.getInteger("numpy_array_alignment_bytes");
    }

    private static Boolean parseOrder(String order) {
        switch (order) {
            case "C": {
                return Boolean.FALSE;
            }
            case "F": {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException(order);
    }
}

