/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.razorvine.serpent.Parser;
import net.razorvine.serpent.ast.Ast;
import numpy.DType;
import numpy.core.NDArray;
import numpy.core.TypeDescriptor;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.CustomUnpickler;
import org.jpmml.python.TupleUtil;

public class NDArrayUtil {
    private static final byte[] MAGIC_STRING = new byte[]{-109, 78, 85, 77, 80, 89};

    private NDArrayUtil() {
    }

    public static int[] getShape(NDArray array) {
        Object[] shape = array.getShape();
        List<Object> values = Arrays.asList(shape);
        return Ints.toArray((Collection)ValueUtil.asIntegers(values));
    }

    public static List<?> getContent(NDArray array) {
        Object content = array.getContent();
        return NDArrayUtil.asJavaList(array, (List)content);
    }

    public static List<?> getContent(NDArray array, String key) {
        Map content = (Map)array.getContent();
        return NDArrayUtil.asJavaList(array, (List)content.get(key));
    }

    public static NDArray toArray(List<?> data) {
        NDArray result = new NDArray();
        result.put("data", data);
        result.put("fortran_order", Boolean.FALSE);
        result.put("shape", new Object[]{data.size()});
        return result;
    }

    private static <E> List<E> asJavaList(NDArray array, List<E> values) {
        return NDArrayUtil.asJavaList(array, values, false);
    }

    private static <E> List<E> asJavaList(NDArray array, List<E> values, boolean fortranOrderShape) {
        boolean fortranOrder = array.getFortranOrder();
        if (fortranOrder) {
            int[] shape = NDArrayUtil.getShape(array);
            switch (shape.length) {
                case 1: {
                    return values;
                }
                case 2: {
                    if (fortranOrderShape) {
                        shape = new int[]{shape[1], shape[0]};
                    }
                    return NDArrayUtil.toJavaList(values, shape[0], shape[1]);
                }
            }
            throw new IllegalArgumentException();
        }
        return values;
    }

    private static <E> List<E> toJavaList(List<E> values, int rows, int columns) {
        ArrayList<E> result = new ArrayList<E>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            int row = i / columns;
            int column = i % columns;
            E value = values.get(column * rows + row);
            result.add(value);
        }
        return result;
    }

    public static NDArray parseNpy(InputStream is) throws IOException {
        byte[] magicBytes = new byte[MAGIC_STRING.length];
        ByteStreams.readFully((InputStream)is, (byte[])magicBytes);
        if (!Arrays.equals(magicBytes, MAGIC_STRING)) {
            throw new IOException();
        }
        int majorVersion = NDArrayUtil.readUnsignedByte(is);
        int minorVersion = NDArrayUtil.readUnsignedByte(is);
        if (majorVersion != 1 || minorVersion != 0) {
            throw new IOException();
        }
        int headerLength = NDArrayUtil.readUnsignedShort(is, ByteOrder.LITTLE_ENDIAN);
        if (headerLength < 0) {
            throw new IOException();
        }
        byte[] headerBytes = new byte[headerLength];
        ByteStreams.readFully((InputStream)is, (byte[])headerBytes);
        String header = new String(headerBytes);
        header = header.trim();
        Map<String, ?> headerDict = NDArrayUtil.parseDict(header);
        Object descr = headerDict.get("descr");
        Boolean fortranOrder = (Boolean)headerDict.get("fortran_order");
        Object[] shape = (Object[])headerDict.get("shape");
        byte[] data = ByteStreams.toByteArray((InputStream)is);
        NDArray array = new NDArray();
        array.__setstate__(new Object[]{Arrays.asList(majorVersion, minorVersion), shape, descr, fortranOrder, data});
        return array;
    }

    public static Object parseData(InputStream is, Object descr, Object[] shape) throws IOException {
        return NDArrayUtil.parseData(is, descr, shape, null);
    }

    public static Object parseData(InputStream is, Object descr, Object[] shape, Integer numpyArrayAlignmentBytes) throws IOException {
        Integer wSize = null;
        if (descr instanceof DType) {
            DType dtype = (DType)descr;
            wSize = dtype.getWSize();
            descr = dtype.toDescr();
        }
        int length = 1;
        for (int i = 0; i < shape.length; ++i) {
            length *= ValueUtil.asInt((Number)((Number)shape[i]));
        }
        if (descr instanceof String) {
            return NDArrayUtil.parseArray(is, (String)descr, length, numpyArrayAlignmentBytes);
        }
        List dims = (List)descr;
        LinkedHashMap result = new LinkedHashMap();
        List<Object[]> objects = NDArrayUtil.parseMultiArray(is, TupleUtil.extractElementList(dims, 1), length, wSize, numpyArrayAlignmentBytes);
        for (int i = 0; i < dims.size(); ++i) {
            Object[] dim = (Object[])dims.get(i);
            result.put((String)dim[0], TupleUtil.extractElementList(objects, i));
        }
        return result;
    }

    public static List<Object> parseArray(InputStream is, String descr, int length, Integer numpyArrayAlignmentBytes) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>(length);
        TypeDescriptor descriptor = new TypeDescriptor(descr);
        if (!descriptor.isObject() && numpyArrayAlignmentBytes != null) {
            NDArrayUtil.skipPadding(is, numpyArrayAlignmentBytes);
        }
        while (result.size() < length) {
            Object element = descriptor.read(is);
            if (descriptor.isObject()) {
                NDArray array = (NDArray)element;
                List content = (List)array.getContent();
                result.addAll(NDArrayUtil.asJavaList(array, content, array.getFortranOrder()));
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public static List<Object[]> parseMultiArray(InputStream is, List<String> descrs, int length, Integer wSize, Integer numpyArrayAlignmentBytes) throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>(length);
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>();
        int size = 0;
        for (String descr : descrs) {
            TypeDescriptor descriptor = new TypeDescriptor(descr);
            if (descriptor.isObject()) {
                throw new IllegalArgumentException(descr);
            }
            descriptors.add(descriptor);
            size += descriptor.getSize();
        }
        Integer skipBytes = null;
        if (wSize != null && (skipBytes = Integer.valueOf(wSize - size)) < 0) {
            throw new IllegalArgumentException();
        }
        if (numpyArrayAlignmentBytes != null) {
            NDArrayUtil.skipPadding(is, numpyArrayAlignmentBytes);
        }
        for (int i = 0; i < length; ++i) {
            Object[] element = new Object[descriptors.size()];
            for (int j = 0; j < descriptors.size(); ++j) {
                TypeDescriptor descriptor = (TypeDescriptor)descriptors.get(j);
                element[j] = descriptor.read(is);
            }
            if (skipBytes != null && skipBytes > 0) {
                int skippedBytes = 0;
                while (skippedBytes < skipBytes) {
                    skippedBytes = (int)((long)skippedBytes + is.skip(skipBytes - skippedBytes));
                }
            }
            result.add(element);
        }
        return result;
    }

    public static Map<String, ?> parseDict(String string) {
        Parser parser = new Parser();
        Ast ast = parser.parse(string);
        return (Map)ast.getData();
    }

    public static byte readByte(InputStream is) throws IOException {
        int b = is.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public static int readUnsignedByte(InputStream is) throws IOException {
        int b = is.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public static short readShort(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return (short)NDArrayUtil.toShortInt(b1, b2);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return (short)NDArrayUtil.toShortInt(b2, b1);
        }
        throw new IOException();
    }

    public static int readUnsignedShort(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toShortInt(b1, b2);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toShortInt(b2, b1);
        }
        throw new IOException();
    }

    public static int readInt(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        byte b3 = NDArrayUtil.readByte(is);
        byte b4 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)b1, (byte)b2, (byte)b3, (byte)b4);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)b4, (byte)b3, (byte)b2, (byte)b1);
        }
        throw new IOException();
    }

    public static long readLong(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        byte b3 = NDArrayUtil.readByte(is);
        byte b4 = NDArrayUtil.readByte(is);
        byte b5 = NDArrayUtil.readByte(is);
        byte b6 = NDArrayUtil.readByte(is);
        byte b7 = NDArrayUtil.readByte(is);
        byte b8 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return Longs.fromBytes((byte)b1, (byte)b2, (byte)b3, (byte)b4, (byte)b5, (byte)b6, (byte)b7, (byte)b8);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Longs.fromBytes((byte)b8, (byte)b7, (byte)b6, (byte)b5, (byte)b4, (byte)b3, (byte)b2, (byte)b1);
        }
        throw new IOException();
    }

    public static float readFloat(InputStream is, ByteOrder byteOrder) throws IOException {
        return Float.intBitsToFloat(NDArrayUtil.readInt(is, byteOrder));
    }

    public static double readDouble(InputStream is, ByteOrder byteOrder) throws IOException {
        return Double.longBitsToDouble(NDArrayUtil.readLong(is, byteOrder));
    }

    public static Object readObject(InputStream is) throws IOException {
        CustomUnpickler unpickler = new CustomUnpickler();
        return unpickler.load(is);
    }

    public static String readString(InputStream is, int size) throws IOException {
        byte[] buffer = new byte[size];
        ByteStreams.readFully((InputStream)is, (byte[])buffer);
        return NDArrayUtil.toString(buffer, "UTF-8");
    }

    public static String readUnicode(InputStream is, ByteOrder byteOrder, int size) throws IOException {
        byte[] buffer = new byte[size * 4];
        ByteStreams.readFully((InputStream)is, (byte[])buffer);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toString(buffer, "UTF-32BE");
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toString(buffer, "UTF-32LE");
        }
        throw new IOException();
    }

    private static void skipPadding(InputStream is, int maxPaddingLength) throws IOException {
        int paddingByte = is.read();
        if (paddingByte == -1) {
            throw new EOFException();
        }
        int paddingLength = paddingByte;
        if (paddingLength < 0 || paddingLength > maxPaddingLength) {
            throw new IOException();
        }
        if (paddingLength != 0) {
            for (int i = 0; i < paddingLength; ++i) {
                int padding = is.read();
                if (padding == -1) {
                    throw new EOFException();
                }
                if (padding == 255) continue;
                throw new IOException();
            }
        }
    }

    private static int toShortInt(byte b1, byte b2) {
        return ((b1 & 0xFF) << 8) + (b2 & 0xFF);
    }

    private static String toString(byte[] buffer, String encoding) throws IOException {
        String string = new String(buffer, encoding);
        while (string.length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

