/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;

import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator extends AbstractTranslator implements PythonParserConstants {

        static
        public Expression translate(String string, Scope scope){
                return translate(string, scope, true);
        }

        static
        public Expression translate(String string, Scope scope, boolean compact){
                Expression expression;

                try {
                        ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
                        expressionTranslator.setScope(scope);

                        expression = expressionTranslator.translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python expression \'" + string + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        ExpressionCompactor compactor = new ExpressionCompactor();

                        compactor.applyTo(expression);
                }

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator) throws ParseException {

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new ParseException();
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                return operator.image;
                }
        }

        static
        private Constant translateConstant(String module, Token value){
                module = FunctionUtil.canonicalizeModule(module);

                if((module).equals("numpy")){

                        switch(value.kind){
                                case NAN:
                                        return PMMLUtil.createMissingConstant();
                                default:
                                        break;
                        }
                } else

                if((module).equals("pandas")){

                        switch(value.kind){
                                case NA:
                                case NAT:
                                        return PMMLUtil.createMissingConstant();
                                default:
                                        break;
                        }
                }

                throw new IllegalArgumentException("Constant \'" + (module + "." + value.image) + "\' is not supported");
        }

        static
        private Expression translateTrailerFunction(Expression expression, String function, List<Expression> arguments){

                if(("startswith").equals(function) || ("endswith").equals(function)){
                        ClassDictUtil.checkSize(1, arguments);

                        Expression argument = arguments.get(0);
                        if(!(argument instanceof Constant)){
                                throw new IllegalArgumentException();
                        }

                        Constant constant = (Constant)argument;
                        if(constant.getDataType() != DataType.STRING){
                                throw new IllegalArgumentException();
                        }

                        String value = (String)constant.getValue();

                        switch(function){
                                case "startswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, 0, value.length()),
                                                constant
                                        );
                                case "endswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, -value.length(), null),
                                                constant
                                        );
                                default:
                                        break;
                        }
                } else

                if(("lower").equals(function) || ("upper").equals(function)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(function){
                                case "lower":
                                        return PMMLUtil.createApply(PMMLFunctions.LOWERCASE, expression);
                                case "upper":
                                        return PMMLUtil.createApply(PMMLFunctions.UPPERCASE, expression);
                                default:
                                        break;
                        }
                } else

                if(("strip").equals(function)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(function){
                                case "strip":
                                        return PMMLUtil.createApply(PMMLFunctions.TRIMBLANKS, expression);
                                default:
                                        break;
                        }
                }

                throw new IllegalArgumentException("Function \'" + function + "\' is not supported");
        }

        static
        private Expression translateFunction(String function, List<Expression> arguments){
                String module;
                String name;

                int dot = function.lastIndexOf('.');
                if(dot > -1){
                        module = function.substring(0, dot);
                        name = function.substring(dot + 1);
                } else

                {
                        module = "";
                        name = function;
                }

                module = FunctionUtil.canonicalizeModule(module);

                return FunctionUtil.encodeFunction(module, name, arguments);
        }

        static
        private Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos){

                if(startPos == null && stopPos == null){
                        return expression;
                }

                Expression offsetExpression;

                if(startPos != null && startPos >= 0){
                        offsetExpression = PMMLUtil.createConstant(startPos + 1, DataType.INTEGER);
                } else

                if(startPos != null && startPos < 0){
                        offsetExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                        PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                        PMMLUtil.createConstant((-startPos) - 1, DataType.INTEGER)
                                ),
                                PMMLUtil.createConstant(1, DataType.INTEGER)
                        );
                } else

                {
                        offsetExpression = PMMLUtil.createConstant(1, DataType.INTEGER);
                } // End if

                Expression lengthExpression;

                if(stopPos != null && stopPos >= 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(0, DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createConstant(stopPos, DataType.INTEGER);
                        }
                } else

                if(stopPos != null && stopPos < 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(startPos + (-stopPos))
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(-stopPos)
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        }
                } else

                {
                        lengthExpression = PMMLUtil.createConstant(Integer.MAX_VALUE, DataType.INTEGER);
                }

                return PMMLUtil.createApply(PMMLFunctions.SUBSTRING, expression, offsetExpression, lengthExpression);
        }

        static
        private Object translateValue(Token value) throws ParseException {
                String image = value.image;

                switch(value.kind){
                        case NONE:
                                return null;
                        case FALSE:
                        case TRUE:
                                return Boolean.valueOf(translateBoolean(image));
                        case INT:
                                return Integer.valueOf(translateInt(image));
                        case FLOAT:
                                return Double.valueOf(image);
                        case STRING:
                                return translateString(image);
                        default:
                                throw new ParseException();
                }
        }

  final public Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
}

  final public Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
}

  final public Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = Expression();
      jj_consume_token(ELSE);
      right = Expression();
left = PMMLUtil.createApply(PMMLFunctions.IF, center, left, right);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
return left;
}

  final public Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = PMMLUtil.createApply(PMMLFunctions.OR, left, right);
    }
return left;
}

  final public Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = PMMLUtil.createApply(PMMLFunctions.AND, left, right);
    }
return left;
}

  final public Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return PMMLUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
}

  final public Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Object right;
    if (jj_2_1(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISMISSING, left);
    } else if (jj_2_2(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NOT);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, left);
    } else if (jj_2_3(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISIN, left).addExpressions((Expression[])right);
    } else if (jj_2_4(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(NOT);
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISNOTIN, left).addExpressions((Expression[])right);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:
      case PLUS:
      case MINUS:
      case FALSE:
      case NONE:
      case TRUE:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:{
        left = AdditiveExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = AdditiveExpression();
left = PMMLUtil.createApply(translateRelationalOperator(operator), left, (Expression)right);
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return left;
}

  final public Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
Scope scope = ensureScope();

                if((operator.kind == PLUS) && (TypeUtil.isString(left, scope) && TypeUtil.isString(right, scope))){
                        left = PMMLUtil.createApply(PMMLFunctions.CONCAT, left, right);
                } else

                {
                        left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
                }
    }
return left;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final public Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:{
      expression = PrimaryExpression();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        expression = PMMLUtil.toNegative(expression);
                }

                return expression;
}

  final public Expression PrimaryExpression() throws ParseException {String featureOrFunction;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      featureOrFunction = DottedName();
      if (jj_2_5(2147483647)) {
        expression = ArrayIndexingExpression(featureOrFunction);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:{
            ;
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            break label_5;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:{
            expression = TrailerFunctionInvocationExpression(expression);
            break;
            }
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            break;
            }
          default:
            jj_la1[14] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          expression = FunctionInvocationExpression(featureOrFunction);
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LBRACKET:
            case DOT:{
              ;
              break;
              }
            default:
              jj_la1[15] = jj_gen;
              break label_6;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOT:{
              expression = TrailerFunctionInvocationExpression(expression);
              break;
              }
            case LBRACKET:{
              expression = StringSlicingExpression(expression);
              break;
              }
            default:
              jj_la1[16] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case DOT:{
          expression = ConstantExpression(featureOrFunction);
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          expression = NameInvocationExpression(featureOrFunction);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            label_7:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case LBRACKET:
              case DOT:{
                ;
                break;
                }
              default:
                jj_la1[17] = jj_gen;
                break label_7;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case DOT:{
                expression = TrailerFunctionInvocationExpression(expression);
                break;
                }
              case LBRACKET:{
                expression = StringSlicingExpression(expression);
                break;
                }
              default:
                jj_la1[18] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            break;
            }
          default:
            jj_la1[19] = jj_gen;
            ;
          }
        }
      }
      break;
      }
    case LPAREN:{
      expression = ParenthesizedExpression();
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_8;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          expression = TrailerFunctionInvocationExpression(expression);
          break;
          }
        case LBRACKET:{
          expression = StringSlicingExpression(expression);
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case STRING:{
      expression = LiteralExpression();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final public String DottedName() throws ParseException {Token name;
        StringBuilder sb = new StringBuilder();
    name = jj_consume_token(NAME);
sb.append(name.image);
    label_9:
    while (true) {
      if (jj_2_6(2147483647)) {
        ;
      } else {
        break label_9;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
sb.append('.').append(name.image);
    }
return sb.toString();
}

  final public FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {Token sign = null;
        Token column;

        Feature feature;
    if (jj_2_7(2147483647)) {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        sign = Sign();
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        int colIndex = parseInt(sign, column);

                        feature = scope.getFeature(dottedName, colIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        column = jj_consume_token(STRING);
        jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        String colName = translateString(column.image);

                        feature = scope.getFeature(dottedName, colName);
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return feature.ref();
}

  final public Expression FunctionInvocationExpression(String dottedName) throws ParseException {List<Expression> arguments;
    arguments = Arguments();
Scope scope = ensureScope();

                int dot = dottedName.lastIndexOf('.');
                if(dot > -1){
                        String featureName = dottedName.substring(0, dot);
                        String functionName = dottedName.substring(dot + 1);

                        Feature feature = scope.resolveFeature(featureName);
                        if(feature != null){
                                return translateTrailerFunction(feature.ref(), functionName, arguments);
                        }
                }

                return translateFunction(dottedName, arguments);
}

  final public Expression TrailerFunctionInvocationExpression(Expression expression) throws ParseException {Token name;
        List<Expression> arguments;
    jj_consume_token(DOT);
    name = jj_consume_token(NAME);
    arguments = Arguments();
return translateTrailerFunction(expression, name.image, arguments);
}

  final public List<Expression> Arguments() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    if (jj_2_8(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expression = Expression();
expressions.add(expression);
        label_10:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_10;
          }
          jj_consume_token(COMMA);
          expression = Expression();
expressions.add(expression);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expressions;
}

  final public Expression StringSlicingExpression(Expression expression) throws ParseException {Token startSign = null;
        Token start = null;
        Token stopSign = null;
        Token stop = null;
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        startSign = Sign();
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      start = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        stopSign = Sign();
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      stop = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
Integer startPos = null;
                if(start != null){
                        startPos = parseInt(startSign, start);
                }

                Integer stopPos = null;
                if(stop != null){
                        stopPos = parseInt(stopSign, stop);
                }

                return translateStringSlice(expression, startPos, stopPos);
}

  final public Constant ConstantExpression(String dottedName) throws ParseException {Token value;
    jj_consume_token(DOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NA:{
      value = jj_consume_token(NA);
      break;
      }
    case NAN:{
      value = jj_consume_token(NAN);
      break;
      }
    case NAT:{
      value = jj_consume_token(NAT);
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return translateConstant(dottedName, value);
}

  final public FieldRef NameInvocationExpression(String dottedName) throws ParseException {
Scope scope = ensureScope();

                Feature feature = scope.getFeature(dottedName);

                return feature.ref();
}

  final public Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
}

  final public Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
        Boolean missing = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:{
      value = jj_consume_token(NONE);
dataType = null; missing = Boolean.TRUE;
      break;
      }
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(translateValue(value))
                        .setDataType(dataType)
                        .setMissing(missing);

                return constant;
}

  final public Expression[] ListMakerExpression() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    jj_consume_token(LBRACKET);
    expression = Expression();
expressions.add(expression);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
    jj_consume_token(RBRACKET);
return expressions.toArray(new Expression[expressions.size()]);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_3R_ComparisonExpression_553_17_78()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_Arguments_750_9_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Arguments_751_17_62()) {
    jj_scanpos = xsp;
    if (jj_3R_Arguments_754_17_63()) return true;
    }
    return false;
  }

  private boolean jj_3R_ListMakerExpression_868_81_85()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_552_9_77()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_553_17_78()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_556_17_79()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_559_17_80()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_562_17_81()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_565_17_82()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_521_39_76()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_NegationExpression_534_9_75()) return true;
    return false;
  }

  private boolean jj_3R_TrailerFunctionInvocationExpression_737_9_61()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    if (jj_3R_Arguments_750_9_55()) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_508_41_74()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_LogicalAndExpression_521_9_73()) return true;
    return false;
  }

  private boolean jj_3R_NegationExpression_534_9_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_552_9_77()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_644_88_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_644_88_56()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_644_151_57()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_84_43()
 {
    if (jj_3R_StringSlicingExpression_770_9_58()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_648_135_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_644_88_56()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_737_9_61()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_IfElseExpression_495_40_69()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_642_83_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_642_83_53()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_642_146_54()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_642_83_53()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_737_9_61()) return true;
    return false;
  }

  private boolean jj_3R_null_683_39_14()
 {
    if (jj_3R_Sign_453_9_19()) return true;
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_521_9_73()
 {
    if (jj_3R_NegationExpression_534_9_75()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalAndExpression_521_39_76()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_FunctionInvocationExpression_711_9_39()
 {
    if (jj_3R_Arguments_750_9_55()) return true;
    return false;
  }

  private boolean jj_3R_DottedName_667_52_37()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_684_29_22()
 {
    if (jj_3R_Sign_453_9_19()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_null_683_39_14()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_651_58_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_651_58_45()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_651_121_46()) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_692_17_18()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(STRING)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_651_58_45()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_737_9_61()) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_508_9_68()
 {
    if (jj_3R_LogicalAndExpression_521_9_73()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalOrExpression_508_41_74()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_683_17_17()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_684_29_22()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_IfElseExpression_495_9_60()
 {
    if (jj_3R_LogicalOrExpression_508_9_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IfElseExpression_495_40_69()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_682_9_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_683_17_17()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayIndexingExpression_692_17_18()) return true;
    }
    return false;
  }

  private boolean jj_3R_ListMakerExpression_868_9_83()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ListMakerExpression_868_81_85()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_Expression_481_9_44()
 {
    if (jj_3R_IfElseExpression_495_9_60()) return true;
    return false;
  }

  private boolean jj_3R_DottedName_667_9_29()
 {
    if (jj_scan_token(NAME)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_DottedName_667_52_37()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_ArrayIndexingExpression_682_9_13()) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_849_17_52()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_25_33()
 {
    if (jj_3R_NameInvocationExpression_810_9_42()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_648_84_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LiteralExpression_847_17_51()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_646_25_32()
 {
    if (jj_3R_ConstantExpression_792_9_41()) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_845_17_50()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_653_17_28()
 {
    if (jj_3R_LiteralExpression_838_9_36()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_644_25_31()
 {
    if (jj_3R_FunctionInvocationExpression_711_9_39()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_644_88_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_LiteralExpression_843_17_49()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_651_17_27()
 {
    if (jj_3R_ParenthesizedExpression_824_9_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_651_58_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_LiteralExpression_841_17_48()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_641_25_30()
 {
    if (jj_3R_ArrayIndexingExpression_682_9_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_642_83_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_LiteralExpression_839_17_47()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_639_17_26()
 {
    if (jj_3R_DottedName_667_9_29()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_641_25_30()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_644_25_31()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_646_25_32()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_648_25_33()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_LiteralExpression_838_9_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LiteralExpression_839_17_47()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_841_17_48()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_843_17_49()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_845_17_50()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_847_17_51()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_849_17_52()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_198_67()
 {
    if (jj_3R_StringSlicingExpression_770_9_58()) return true;
    return false;
  }

  private boolean jj_3R_Sign_453_9_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) return true;
    }
    return false;
  }

  private boolean jj_3R_Arguments_754_87_70()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_770_69_72()
 {
    if (jj_3R_Sign_453_9_19()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_638_9_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_639_17_26()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_651_17_27()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_653_17_28()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_770_68_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_770_69_72()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesizedExpression_824_9_34()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_604_35_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) return true;
    }
    }
    if (jj_3R_UnaryExpression_617_9_20()) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_620_17_24()
 {
    if (jj_3R_PrimaryExpression_638_9_25()) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_618_17_23()
 {
    if (jj_3R_Sign_453_9_19()) return true;
    if (jj_3R_UnaryExpression_617_9_20()) return true;
    return false;
  }

  private boolean jj_3R_NameInvocationExpression_810_9_42()
 {
    return false;
  }

  private boolean jj_3R_UnaryExpression_617_9_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnaryExpression_618_17_23()) {
    jj_scanpos = xsp;
    if (jj_3R_UnaryExpression_620_17_24()) return true;
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_580_44_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) return true;
    }
    if (jj_3R_MultiplicativeExpression_604_9_15()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_604_9_15()
 {
    if (jj_3R_UnaryExpression_617_9_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MultiplicativeExpression_604_35_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ComparisonExpression_565_46_84()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    }
    }
    }
    }
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    return false;
  }

  private boolean jj_3R_ConstantExpression_792_9_41()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_644_151_57()
 {
    if (jj_3R_StringSlicingExpression_770_9_58()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_770_22_71()
 {
    if (jj_3R_Sign_453_9_19()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_770_21_64()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_770_22_71()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_642_146_54()
 {
    if (jj_3R_StringSlicingExpression_770_9_58()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_135_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_648_135_66()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_648_198_67()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_135_66()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_737_9_61()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_580_9_12()
 {
    if (jj_3R_MultiplicativeExpression_604_9_15()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AdditiveExpression_580_44_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_770_9_58()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_770_21_64()) jj_scanpos = xsp;
    if (jj_scan_token(COLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_770_68_65()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_565_17_82()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_565_46_84()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_651_121_46()
 {
    if (jj_3R_StringSlicingExpression_770_9_58()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_Arguments_754_17_63()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_Expression_481_9_44()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Arguments_754_87_70()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_562_17_81()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_868_9_83()) return true;
    return false;
  }

  private boolean jj_3R_Arguments_751_17_62()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_559_17_80()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_868_9_83()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_556_17_79()
 {
    if (jj_3R_AdditiveExpression_580_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[35];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xc000,0x0,0x20,0x40,0x80,0x3f00,0x3f00,0x6200c008,0xc000,0xc000,0x70000,0x70000,0x6200c008,0x900000,0x900000,0x900000,0x900000,0x900000,0x900000,0x100000,0x800008,0x900000,0x900000,0x62000008,0xc000,0x100000,0x400000,0x8,0xc000,0xc000,0xc000,0xc000,0x1c000000,0x62000000,0x400000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x58,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[8];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PythonParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 35; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PythonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 35; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 35; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 35; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[43];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 35; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 43; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : PythonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 8; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
