/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import java.util.List;
import java.util.Map;
import net.razorvine.pickle.objects.ClassDictConstructor;
import numpy.core.NDArray;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.CythonObject;
import org.jpmml.python.HasArray;
import org.jpmml.python.PythonObject;
import org.jpmml.python.SliceUtil;

public class Index
extends CythonObject
implements HasArray {
    private static final String[] INIT_ATTRIBUTES = new String[]{"cls", "data"};
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"state"};

    public Index(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        super.__setstate__(INIT_ATTRIBUTES, args);
    }

    @Override
    public void __setstate__(Object[] args) {
        super.__setstate__(SETSTATE_ATTRIBUTES, args);
    }

    @Override
    public List<?> getArrayContent() {
        return this.getValues();
    }

    @Override
    public int[] getArrayShape() {
        List<?> values = this.getArrayContent();
        return new int[]{values.size()};
    }

    @Override
    public Object getArrayType() {
        return this.getDescr();
    }

    public Object getDescr() {
        Data data = this.getData();
        return data.getDescr();
    }

    public List<?> getValues() {
        Data data = this.getData();
        return data.getValues();
    }

    public String getCls() {
        ClassDictConstructor dictConstructor = this.get("cls", ClassDictConstructor.class);
        return ClassDictConstructorUtil.getClassName(dictConstructor);
    }

    public Data getData() {
        String cls;
        switch (cls = this.getCls()) {
            case "pandas.core.indexes.range.RangeIndex": {
                return this.getPythonObject("data", new RangeData());
            }
        }
        return this.getPythonObject("data", new NDArrayData(this.getPythonModule(), "data"));
    }

    private <E extends PythonObject> E getPythonObject(String name, E object) {
        Map<String, ?> dict = this.getDict(name);
        if (dict.containsKey("__class__")) {
            throw new AttributeException("Dict attribute '" + ClassDictUtil.formatMember(this, name) + "' has a non-dict value (" + ClassDictUtil.formatClass(dict) + ")");
        }
        object.update(dict);
        return object;
    }

    public abstract class Data
    extends PythonObject {
        public Data(String module, String name) {
            super(module, name);
        }

        public abstract Object getDescr();

        public abstract List<?> getValues();
    }

    public class NDArrayData
    extends Data {
        public NDArrayData(String module, String name) {
            super(module, name);
        }

        @Override
        public Object getDescr() {
            NDArray data = this.getData();
            return data.getDescr();
        }

        @Override
        public List<?> getValues() {
            NDArray data = this.getData();
            return data.getArrayContent();
        }

        public NDArray getData() {
            return this.get("data", NDArray.class);
        }
    }

    public class RangeData
    extends Data {
        public RangeData() {
            super("pandas.core.indexes.range", "RangeIndex");
        }

        @Override
        public Object getDescr() {
            return "i4";
        }

        @Override
        public List<?> getValues() {
            int start = this.getStart();
            int stop = this.getStop();
            int step = this.getStep();
            return SliceUtil.indices(start, stop, step);
        }

        public Integer getStart() {
            return this.getInteger("start");
        }

        public Integer getStop() {
            return this.getInteger("stop");
        }

        public Integer getStep() {
            return this.getInteger("step");
        }
    }
}

