/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.python;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator extends AbstractTranslator implements PythonParserConstants {

        private Deque<String> indents = new ArrayDeque<>();

        private Map<String, FieldRef> variableMap = new LinkedHashMap<>();


        public ExpressionTranslator(Scope scope){
                this(new NullProvider());

                setScope(scope);
        }

        public DefineFunction translateDef(String string){
                ReInit(new StringProvider(ensureTerminator(string)));

                DefineFunction defineFunction;

                try {
                        defineFunction = translateDefInternal();
                } catch(ParseException pe){
                        throw new TranslationException("Python function definition \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                return defineFunction;
        }

        public Expression translateStatement(String string){
                return translateStatement(string, true);
        }

        public Expression translateStatement(String string, boolean compact){
                ReInit(new StringProvider(ensureTerminator(string)));

                Expression statement;

                try {
                        statement = translateStatementInternal();
                } catch(ParseException pe){
                        throw new TranslationException("Python statement \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        statement = compact(statement);
                }

                return statement;
        }

        public Expression translateExpression(String string){
                return translateExpression(string, true);
        }

        public Expression translateExpression(String string, boolean compact){
                ReInit(new StringProvider(string));

                Expression expression;

                try {
                        expression = translateExpressionInternal();
                } catch(ParseException pe){
                        throw new TranslationException("Python expression \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        expression = compact(expression);
                }

                return expression;
        }

        public Constant encodeConstant(String dottedName){

                switch(dottedName){
                        case "math.e":
                        case "numpy.e":
                                return ExpressionUtil.createConstant(DataType.DOUBLE, Math.E);
                        case "numpy.NZERO":
                                return ExpressionUtil.createConstant(DataType.DOUBLE, -0.0d);
                        case "math.pi":
                        case "numpy.pi":
                                return ExpressionUtil.createConstant(DataType.DOUBLE, Math.PI);
                        case "numpy.PZERO":
                                return ExpressionUtil.createConstant(DataType.DOUBLE, 0.0);
                        case "math.tau":
                                return ExpressionUtil.createConstant(DataType.DOUBLE, 2 * Math.PI);
                        default:
                                break;
                }

                switch(dottedName){
                        // Math
                        case "math.nan":
                        // Numpy
                        case "numpy.nan":
                        case "numpy.NaN":
                        case "numpy.NAN":
                        // Pandas
                        case "pandas.NA":
                        case "pandas.NaT":
                                return ExpressionUtil.createMissingConstant();
                        default:
                                break;
                }

                throw new TranslationException("Constant \'" + dottedName + "\' is not supported");
        }

        private void checkAssignment(Token name) throws ParseException {

                if(name != null){
                        throw new ParseException("Invalid syntax");
                }
        }

        private String getIndent() throws ParseException {
                Token nextToken = getToken(1);

                return PythonParserUtil.getWhitespace(nextToken);
        }

        private void checkIndent(String indent) throws ParseException {
                String expectedIndent = this.indents.peek();

                if(!(indent).equals(expectedIndent)){
                        throw new ParseException("Unexpected indent");
                }
        }

        static
        public Expression compact(Expression expression){
                ExpressionCompactor expressionCompactor = new ExpressionCompactor();

                expressionCompactor.applyTo(expression);

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator) throws ParseException {

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new ParseException();
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                return operator.image;
                }
        }

        static
        private Apply translateTrailerFunction(Expression expression, String name, List<Expression> arguments){

                if(("startswith").equals(name) || ("endswith").equals(name)){
                        ClassDictUtil.checkSize(1, arguments);

                        Expression argument = arguments.get(0);
                        if(!(argument instanceof Constant)){
                                throw new IllegalArgumentException();
                        }

                        Constant constant = (Constant)argument;
                        if(constant.getDataType() != DataType.STRING){
                                throw new IllegalArgumentException();
                        }

                        String value = (String)constant.getValue();

                        switch(name){
                                case "startswith":
                                        return ExpressionUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, 0, value.length()),
                                                constant
                                        );
                                case "endswith":
                                        return ExpressionUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, -value.length(), null),
                                                constant
                                        );
                                default:
                                        break;
                        }
                } else

                if(("lower").equals(name) || ("upper").equals(name)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(name){
                                case "lower":
                                        return ExpressionUtil.createApply(PMMLFunctions.LOWERCASE, expression);
                                case "upper":
                                        return ExpressionUtil.createApply(PMMLFunctions.UPPERCASE, expression);
                                default:
                                        break;
                        }
                } else

                if(("strip").equals(name)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(name){
                                case "strip":
                                        return ExpressionUtil.createApply(PMMLFunctions.TRIMBLANKS, expression);
                                default:
                                        break;
                        }
                }

                throw new TranslationException("Function \'" + name + "\' is not supported");
        }

        static
        private Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos){

                if(startPos == null && stopPos == null){
                        return expression;
                }

                Expression offsetExpression;

                if(startPos != null && startPos >= 0){
                        offsetExpression = ExpressionUtil.createConstant(DataType.INTEGER, startPos + 1);
                } else

                if(startPos != null && startPos < 0){
                        offsetExpression = ExpressionUtil.createApply(PMMLFunctions.MAX,
                                ExpressionUtil.createApply(PMMLFunctions.SUBTRACT,
                                        ExpressionUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                        ExpressionUtil.createConstant(DataType.INTEGER, (-startPos) - 1)
                                ),
                                ExpressionUtil.createConstant(DataType.INTEGER, 1)
                        );
                } else

                {
                        offsetExpression = ExpressionUtil.createConstant(DataType.INTEGER, 1);
                } // End if

                Expression lengthExpression;

                if(stopPos != null && stopPos >= 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = ExpressionUtil.createConstant(DataType.INTEGER, Math.max(stopPos - startPos, 0));
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = ExpressionUtil.createConstant(DataType.INTEGER, 0);
                        } else

                        {
                                lengthExpression = ExpressionUtil.createConstant(DataType.INTEGER, stopPos);
                        }
                } else

                if(stopPos != null && stopPos < 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = ExpressionUtil.createApply(PMMLFunctions.MAX,
                                        ExpressionUtil.createApply(PMMLFunctions.SUBTRACT,
                                                ExpressionUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                ExpressionUtil.createConstant(DataType.INTEGER, startPos + (-stopPos))
                                        ),
                                        ExpressionUtil.createConstant(DataType.INTEGER, 0)
                                );
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = ExpressionUtil.createConstant(DataType.INTEGER, Math.max(stopPos - startPos, 0));
                        } else

                        {
                                lengthExpression = ExpressionUtil.createApply(PMMLFunctions.MAX,
                                        ExpressionUtil.createApply(PMMLFunctions.SUBTRACT,
                                                ExpressionUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                ExpressionUtil.createConstant(DataType.INTEGER, -stopPos)
                                        ),
                                        ExpressionUtil.createConstant(DataType.INTEGER, 0)
                                );
                        }
                } else

                {
                        lengthExpression = ExpressionUtil.createConstant(DataType.INTEGER, Integer.MAX_VALUE);
                }

                return ExpressionUtil.createApply(PMMLFunctions.SUBSTRING, expression, offsetExpression, lengthExpression);
        }

        static
        private String ensureTerminator(String string){

                if(string.endsWith("\n")){

                        if(!string.endsWith("\n\n")){
                                string += "\n";
                        }
                }

                return string;
        }

        static
        private Expression getOnlyStatement(List<Expression> statements){

                for(Iterator<Expression> it = statements.iterator(); it.hasNext(); ){
                        Expression statement = it.next();

                        if(statement == null){
                                it.remove();
                        }
                }

                if(statements.size() == 0){
                        throw new TranslationException("Block does not contain any PMML-compatible statements");
                } else

                if(statements.size() == 1){
                        return statements.get(0);
                } else

                {
                        throw new TranslationException("Block contains more than one PMML-compatible statements");
                }
        }

        static
        private class Block extends ArrayList<Expression> {

                private Block(List<Expression> statements){
                        super(statements);
                }

                Expression getOnlyStatement(){
                        return ExpressionTranslator.getOnlyStatement(this);
                }
        }

  final private Token String() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      token = jj_consume_token(STRING);
      break;
      }
    case MULTILINE_STRING:{
      token = jj_consume_token(MULTILINE_STRING);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private int ColumnIndex() throws ParseException {Token sign = null;
        Token column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    column = jj_consume_token(INT);
return PythonParserUtil.parseInt(sign, column);
}

  final private int ArrayColumnIndex() throws ParseException {int columnIndex;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        columnIndex = ColumnIndex();
        jj_consume_token(RBRACKET);
        break;
        }
      case PLUS:
      case MINUS:
      case INT:{
        columnIndex = ColumnIndex();
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case PLUS:
    case MINUS:
    case INT:{
      columnIndex = ColumnIndex();
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columnIndex;
}

  final private String ColumnName() throws ParseException {Token column;
    column = String();
return PythonParserUtil.parseString(column);
}

  final private String DottedName() throws ParseException {Token name;
        StringBuilder sb = new StringBuilder();
    name = jj_consume_token(NAME);
sb.append(name.image);
    label_1:
    while (true) {
      if (jj_2_1(2147483647)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
sb.append('.').append(name.image);
    }
return sb.toString();
}

  final private String CanonicalizedDottedName() throws ParseException {String dottedName;
    dottedName = DottedName();
return canonicalizeDottedName(dottedName);
}

  final private DefineFunction translateDefInternal() throws ParseException {DefineFunction defineFunction;
    defineFunction = Def();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      jj_consume_token(NEWLINE);
    }
    jj_consume_token(0);
return defineFunction;
}

  final private Expression translateStatementInternal() throws ParseException {List<Expression> expressions;
    expressions = Statement();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(NEWLINE);
    }
    jj_consume_token(0);
return getOnlyStatement(expressions);
}

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
}

  final private DefineFunction Def() throws ParseException {Token name;
        List<Token> parameters;
        Block block;
this.variableMap.clear();
    jj_consume_token(DEF);
    name = jj_consume_token(NAME);
    parameters = Parameters();
    jj_consume_token(COLON);
    block = Block();
this.variableMap.clear();

                DefineFunction defineFunction = createDefineFunction(name.image, block.getOnlyStatement());

                for(int i = 0; i < parameters.size(); i++){
                        Token parameter = parameters.get(i);

                        defineFunction.addParameterFields(new ParameterField(parameter.image));
                }

                return defineFunction;
}

  final private List<Token> Parameters() throws ParseException {Token name;
        List<Token> names = new ArrayList();
    if (jj_2_2(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        name = jj_consume_token(NAME);
names.add(name);
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            break label_4;
          }
          jj_consume_token(COMMA);
          name = jj_consume_token(NAME);
names.add(name);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return names;
}

  final private Block Block() throws ParseException {List<Expression> statements;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NEWLINE:{
      label_5:
      while (true) {
        jj_consume_token(NEWLINE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_5;
        }
      }
      Indent();
      statements = Statements();
      Dedent();
      break;
      }
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case IMPORT:
    case RETURN:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      statements = SimpleStatements();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new Block(statements);
}

  private void Indent() throws ParseException {String indent = getIndent();

        if(!this.indents.isEmpty()){
                String prevIndent = this.indents.peek();

                if(!(indent).startsWith(prevIndent)){
                        throw new ParseException();
                }
        }

        this.indents.push(indent);
  }

  private void Dedent() throws ParseException {this.indents.pop();
  }

  private boolean BlockContinuation() throws ParseException {String expectedIndent = this.indents.peek();

        String indent = getIndent();

        if((indent).equals(expectedIndent)){
                return true;
        }

        return false;
  }

  final private List<Expression> Statements() throws ParseException {List<Expression> statement;
        List<Expression> statements = new ArrayList<>();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        jj_consume_token(NEWLINE);
        break;
        }
      case LPAREN:
      case NOT:
      case PLUS:
      case MINUS:
      case FALSE:
      case NONE:
      case TRUE:
      case IF:
      case IMPORT:
      case RETURN:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:
      case MULTILINE_STRING:{
if(!BlockContinuation()){

                                if(!statements.isEmpty()){
                                        return statements;
                                }
                        }
        statement = Statement();
statements.addAll(statement);
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:
      case LPAREN:
      case NOT:
      case PLUS:
      case MINUS:
      case FALSE:
      case NONE:
      case TRUE:
      case IF:
      case IMPORT:
      case RETURN:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:
      case MULTILINE_STRING:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
    }
return statements;
}

  final private List<Expression> Statement() throws ParseException {Expression statement;
        List<Expression> statements;
String indent = getIndent();

                checkIndent(indent);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      statement = CompoundStatement();
statements = Collections.singletonList(statement);
      break;
      }
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case IMPORT:
    case RETURN:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      statements = SimpleStatements();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return statements;
}

  final private Expression CompoundStatement() throws ParseException {Expression statement;
    statement = IfStatement();
return statement;
}

  final private List<Expression> SimpleStatements() throws ParseException {Expression statement;
        List<Expression> statements = new ArrayList<>();
    statement = SimpleStatement();
statements.add(statement);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_7;
      }
      jj_consume_token(SEMICOLON);
      statement = SimpleStatement();
statements.add(statement);
    }
    jj_consume_token(NEWLINE);
return statements;
}

  final private Expression SimpleStatement() throws ParseException {Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      expression = Assignment();
      break;
      }
    case RETURN:{
      expression = ReturnStatement();
      break;
      }
    case IMPORT:{
      expression = ImportStatement();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final private Apply IfStatement() throws ParseException {Expression condition;
        Block block;

        Apply if_statement;
        Apply elif_statement;

        Apply tail;
    jj_consume_token(IF);
    condition = Expression();
    jj_consume_token(COLON);
    block = Block();
if_statement = ExpressionUtil.createApply(PMMLFunctions.IF, condition, block.getOnlyStatement()); tail = if_statement;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ELIF:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_8;
      }
      elif_statement = ElIfStatement();
tail.addExpressions(elif_statement); tail = elif_statement;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      block = ElseBlock();
tail.addExpressions(block.getOnlyStatement());
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
return if_statement;
}

  final private Apply ElIfStatement() throws ParseException {Expression condition;
        Block block;
    jj_consume_token(ELIF);
    condition = Expression();
    jj_consume_token(COLON);
    block = Block();
return ExpressionUtil.createApply(PMMLFunctions.IF, condition, block.getOnlyStatement());
}

  final private Block ElseBlock() throws ParseException {Block block;
    jj_consume_token(ELSE);
    jj_consume_token(COLON);
    block = Block();
return block;
}

  final private Expression Assignment() throws ParseException {Token name;
        Expression expression;
    if (jj_2_3(2147483647)) {
      name = jj_consume_token(NAME);
      jj_consume_token(ASSIGN);
    } else {
name = null;
    }
    expression = Expression();
checkAssignment(name);

                return null;
}

  final private Expression ReturnStatement() throws ParseException {Expression expression;
    jj_consume_token(RETURN);
    expression = Expression();
return expression;
}

  final private Expression ImportStatement() throws ParseException {
    jj_consume_token(IMPORT);
    DottedAsName();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      DottedAsName();
    }
return null;
}

  final private void DottedAsName() throws ParseException {String dottedName;
        Token name = null;
    dottedName = DottedName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      name = jj_consume_token(NAME);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
Map<String, String> moduleImports = getModuleImports();

                moduleImports.put(name != null ? name.image : dottedName, dottedName);
}

  final private Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
}

  final private Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = Expression();
      jj_consume_token(ELSE);
      right = Expression();
left = ExpressionUtil.createApply(PMMLFunctions.IF, center, left, right);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
return left;
}

  final private Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_10;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = ExpressionUtil.createApply(PMMLFunctions.OR, left, right);
    }
return left;
}

  final private Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_11;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = ExpressionUtil.createApply(PMMLFunctions.AND, left, right);
    }
return left;
}

  final private Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return ExpressionUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
}

  final private Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Object right;
    left = AdditiveExpression();
    if (jj_2_4(2147483647)) {
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = ExpressionUtil.createApply(PMMLFunctions.ISMISSING, left);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IS:{
        jj_consume_token(IS);
        jj_consume_token(NOT);
        jj_consume_token(NONE);
left = ExpressionUtil.createApply(PMMLFunctions.ISNOTMISSING, left);
        break;
        }
      case IN:{
        jj_consume_token(IN);
        right = ListMakerExpression();
left = ExpressionUtil.createApply(PMMLFunctions.ISIN, left).addExpressions((Expression[])right);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        jj_consume_token(IN);
        right = ListMakerExpression();
left = ExpressionUtil.createApply(PMMLFunctions.ISNOTIN, left).addExpressions((Expression[])right);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[24] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = AdditiveExpression();
left = ExpressionUtil.createApply(translateRelationalOperator(operator), left, (Expression)right);
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          ;
        }
      }
    }
return left;
}

  final private Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
if((operator.kind == PLUS) && (ExpressionUtil.isString(left, this) && ExpressionUtil.isString(right, this))){
                        left = ExpressionUtil.createApply(PMMLFunctions.CONCAT, left, right);
                } else

                {
                        left = ExpressionUtil.createApply(translateArithmeticOperator(operator), left, right);
                }
    }
return left;
}

  final private Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = ExpressionUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final private Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      expression = PowerExpression();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        expression = ExpressionUtil.toNegative(expression);
                }

                return expression;
}

  final private Expression PowerExpression() throws ParseException {Expression left;
        Expression right;
    left = PrimaryExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case POWER:{
      jj_consume_token(POWER);
      right = UnaryExpression();
left = ExpressionUtil.createApply(PMMLFunctions.POW, left, right);
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
return left;
}

  final private Expression PrimaryExpression() throws ParseException {String dottedName;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      dottedName = CanonicalizedDottedName();
      if (jj_2_5(2147483647)) {
        expression = ArrayIndexingExpression(dottedName);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:{
            ;
            break;
            }
          default:
            jj_la1[33] = jj_gen;
            break label_14;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:{
            expression = TrailerFunctionInvocationExpression(expression);
            break;
            }
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            break;
            }
          default:
            jj_la1[34] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          expression = FunctionInvocationExpression(dottedName);
          label_15:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LBRACKET:
            case DOT:{
              ;
              break;
              }
            default:
              jj_la1[35] = jj_gen;
              break label_15;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOT:{
              expression = TrailerFunctionInvocationExpression(expression);
              break;
              }
            case LBRACKET:{
              expression = StringSlicingExpression(expression);
              break;
              }
            default:
              jj_la1[36] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          expression = NameInvocationExpression(dottedName);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            label_16:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case LBRACKET:
              case DOT:{
                ;
                break;
                }
              default:
                jj_la1[37] = jj_gen;
                break label_16;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case DOT:{
                expression = TrailerFunctionInvocationExpression(expression);
                break;
                }
              case LBRACKET:{
                expression = StringSlicingExpression(expression);
                break;
                }
              default:
                jj_la1[38] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            ;
          }
        }
      }
      break;
      }
    case LPAREN:{
      expression = ParenthesizedExpression();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:{
          ;
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          expression = TrailerFunctionInvocationExpression(expression);
          break;
          }
        case LBRACKET:{
          expression = StringSlicingExpression(expression);
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case STRING:
    case MULTILINE_STRING:{
      expression = LiteralExpression();
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final private FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {Scope scope = ensureScope();

        int colIndex;
        String colName;

        Feature feature;
    if (jj_2_6(2147483647)) {
      jj_consume_token(LBRACKET);
      colIndex = ArrayColumnIndex();
      jj_consume_token(RBRACKET);
feature = scope.getFeature(dottedName, colIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        colName = ColumnName();
        jj_consume_token(RBRACKET);
feature = scope.getFeature(dottedName, colName);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return feature.ref();
}

  final private Expression FunctionInvocationExpression(String dottedName) throws ParseException {Scope scope = ensureScope();

        List<Expression> arguments;
    arguments = Arguments();
int dot = dottedName.lastIndexOf('.');
                if(dot > -1){
                        String featureName = dottedName.substring(0, dot);
                        String functionName = dottedName.substring(dot + 1);

                        Feature feature = scope.resolveFeature(featureName);
                        if(feature != null){
                                return translateTrailerFunction(feature.ref(), functionName, arguments);
                        }
                }

                return encodeFunction(dottedName, arguments);
}

  final private Apply TrailerFunctionInvocationExpression(Expression expression) throws ParseException {Token name;
        List<Expression> arguments;
    jj_consume_token(DOT);
    name = jj_consume_token(NAME);
    arguments = Arguments();
return translateTrailerFunction(expression, name.image, arguments);
}

  final private List<Expression> Arguments() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    if (jj_2_7(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expression = Expression();
expressions.add(expression);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[45] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
          expression = Expression();
expressions.add(expression);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expressions;
}

  final private Expression StringSlicingExpression(Expression expression) throws ParseException {Integer startPos = null;
        Integer stopPos = null;
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      startPos = ColumnIndex();
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      stopPos = ColumnIndex();
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
return translateStringSlice(expression, startPos, stopPos);
}

  final private Expression NameInvocationExpression(String dottedName) throws ParseException {Scope scope = ensureScope();
int dot = dottedName.indexOf('.');
                if(dot > -1){
                        return encodeConstant(dottedName);
                }

                FieldRef fieldRef = this.variableMap.get(dottedName);
                if(fieldRef != null){
                        return fieldRef;
                }

                Feature feature = scope.getFeature(dottedName);

                return feature.ref();
}

  final private Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
}

  final private Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
        Boolean missing = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:{
      value = jj_consume_token(NONE);
dataType = null; missing = Boolean.TRUE;
      break;
      }
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:
    case MULTILINE_STRING:{
      value = String();
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(PythonParserUtil.parseValue(value))
                        .setDataType(dataType)
                        .setMissing(missing);

                return constant;
}

  final private Expression[] ListMakerExpression() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    jj_consume_token(LBRACKET);
    expression = Expression();
expressions.add(expression);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
    jj_consume_token(RBRACKET);
return expressions.toArray(new Expression[expressions.size()]);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_ArrayIndexingExpression_1204_17_23()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ColumnName_640_9_26()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_1199_17_22()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ArrayColumnIndex_624_9_21()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_Sign_595_9_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnName_640_9_26()
 {
    if (jj_3R_String_579_9_30()) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_627_17_25()
 {
    if (jj_3R_ColumnIndex_612_9_29()) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_1198_9_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_1199_17_22()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayIndexingExpression_1204_17_23()) return true;
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_625_17_24()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayColumnIndex_625_34_27()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayColumnIndex_625_86_28()) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_ArrayIndexingExpression_1198_9_20()) return true;
    return false;
  }

  private boolean jj_3R_String_579_9_30()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_624_9_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayColumnIndex_625_17_24()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayColumnIndex_627_17_25()) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_ColumnIndex_612_10_31()
 {
    if (jj_3R_Sign_595_9_32()) return true;
    return false;
  }

  private boolean jj_3R_ColumnIndex_612_9_29()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnIndex_612_10_31()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_625_86_28()
 {
    if (jj_3R_ColumnIndex_612_9_29()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ArrayColumnIndex_624_9_21()) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_625_34_27()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ColumnIndex_612_9_29()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[51];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x30000,0x30000,0x830000,0x8030000,0x8,0x8,0x2000000,0x10,0x8,0xe0030118,0xe0030118,0xe0030118,0xe0030110,0x10000000,0xe0030110,0x0,0x0,0x2000000,0x0,0x0,0x40,0x80,0x100,0x7e00,0x7e00,0x100,0x30000,0x30000,0x1c0000,0x1c0000,0xe0030010,0x400000,0x4800000,0x4800000,0x4800000,0x4800000,0x4800000,0x4800000,0x800000,0x10,0x4800000,0x4800000,0xe0000010,0x800000,0x2000000,0x10,0x30000,0x30000,0xe0000000,0x2000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x3000,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x3f20,0x3f30,0x3f30,0x3f30,0x0,0x3f20,0x4,0x8,0x0,0x1,0x10,0x0,0x0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x3e00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e00,0x0,0x0,0x0,0x200,0x200,0x3600,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PythonParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 51; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PythonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 51; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 51; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 51; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[50];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 51; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 50; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : PythonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 7; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
