/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ExpressionTranslator;
import org.jpmml.python.FunctionDef;
import org.jpmml.python.FunctionDefParser;
import org.jpmml.python.FunctionDefScope;
import org.jpmml.python.FunctionUtil;
import org.jpmml.python.ParseException;
import org.jpmml.python.Scope;
import org.jpmml.python.TranslationException;

public abstract class AbstractTranslator
implements FeatureResolver {
    private Scope scope = null;
    private Map<String, FunctionDef> functionDefs = new LinkedHashMap<String, FunctionDef>();
    private Map<String, String> moduleImports = new LinkedHashMap<String, String>();

    public Feature resolveFeature(String name) {
        Scope scope = this.ensureScope();
        return scope.resolveFeature(name);
    }

    public PMMLEncoder ensureEncoder() {
        Scope scope = this.ensureScope();
        PMMLEncoder encoder = scope.getEncoder();
        if (encoder == null) {
            throw new IllegalStateException();
        }
        return encoder;
    }

    public Scope ensureScope() {
        Scope scope = this.getScope();
        if (scope == null) {
            throw new IllegalStateException();
        }
        return scope;
    }

    public FunctionDef getFunctionDef(String name) {
        Map<String, FunctionDef> functionDefs = this.getFunctionDefs();
        return functionDefs.get(name);
    }

    public void addFunctionDef(String string) {
        FunctionDef functionDef;
        Map<String, FunctionDef> functionDefs = this.getFunctionDefs();
        try {
            FunctionDefParser functionDefParser = new FunctionDefParser();
            functionDef = functionDefParser.parseFunctionDef(string);
        }
        catch (ParseException pe) {
            throw new TranslationException("Python function definition '" + AbstractTranslator.toSingleLine(string) + "' is either invalid or not supported", pe);
        }
        functionDefs.put(functionDef.getName(), functionDef);
    }

    public String canonicalizeDottedName(String dottedName) {
        Map<String, String> imports = this.getModuleImports();
        int dot = dottedName.indexOf(46);
        if (dot > -1) {
            String prefix = dottedName.substring(0, dot);
            prefix = imports.getOrDefault(prefix, prefix);
            String suffix = dottedName.substring(dot + 1);
            return prefix + "." + suffix;
        }
        return dottedName;
    }

    public Expression encodeFunction(String dottedName, List<?> arguments) {
        FunctionDef functionDef;
        String name;
        String module;
        int dot = dottedName.lastIndexOf(46);
        if (dot > -1) {
            module = dottedName.substring(0, dot);
            name = dottedName.substring(dot + 1);
            functionDef = null;
        } else {
            module = "builtins";
            name = dottedName;
            functionDef = this.getFunctionDef(name);
        }
        if (functionDef != null) {
            PMMLEncoder encoder = this.ensureEncoder();
            List<FunctionDef.Parameter> parameters = functionDef.getParameters();
            if (arguments.size() != parameters.size()) {
                String nameAndSignature = parameters.stream().map(FunctionDef.Parameter::getName).collect(Collectors.joining(", ", name + "(", ")"));
                throw new TranslationException("Function '" + nameAndSignature + "' expects " + parameters.size() + " argument(s), got " + arguments.size() + " argument(s)");
            }
            List features = arguments.stream().map(argument -> {
                if (argument instanceof FieldRef) {
                    Field field;
                    FieldRef fieldRef = (FieldRef)argument;
                    try {
                        field = encoder.getField(fieldRef.requireField());
                    }
                    catch (IllegalArgumentException iae) {
                        ParameterField parameterField = new ParameterField(fieldRef.requireField()).setOpType(null).setDataType(DataType.STRING);
                        return new ObjectFeature(encoder, (Field)parameterField);
                    }
                    return FeatureUtil.createFeature((Field)field, (PMMLEncoder)encoder);
                }
                return (Feature)argument;
            }).collect(Collectors.toList());
            DefineFunction defineFunction = encoder.getDefineFunction(name);
            if (defineFunction == null) {
                ArrayList<1> parameterFeatures = new ArrayList<1>();
                for (int i = 0; i < parameters.size(); ++i) {
                    FunctionDef.Parameter parameter = parameters.get(i);
                    Feature feature = (Feature)features.get(i);
                    final ParameterField parameterField = new ParameterField(parameter.getName()).setOpType(null).setDataType(feature.getDataType());
                    ObjectFeature parameterFeature = new ObjectFeature(encoder, (Field)parameterField){

                        public Field<?> getField() {
                            return parameterField;
                        }
                    };
                    parameterFeatures.add(parameterFeature);
                }
                FunctionDefScope scope = new FunctionDefScope(functionDef, parameterFeatures, encoder);
                ExpressionTranslator expressionTranslator = new ExpressionTranslator(scope){

                    @Override
                    public FunctionDef getFunctionDef(String name) {
                        return AbstractTranslator.this.getFunctionDef(name);
                    }
                };
                defineFunction = expressionTranslator.translateDef(functionDef.getString());
            }
            Apply apply = ExpressionUtil.createApply((DefineFunction)defineFunction, (Expression[])new Expression[0]);
            for (Feature feature : features) {
                apply.addExpressions(new Expression[]{feature.ref()});
            }
            return apply;
        }
        List<Expression> expressions = arguments.stream().map(argument -> {
            if (argument instanceof Feature) {
                Feature feature = (Feature)argument;
                return feature.ref();
            }
            return (Expression)argument;
        }).collect(Collectors.toList());
        return FunctionUtil.encodeFunction(module, name, expressions);
    }

    protected DefineFunction createDefineFunction(String name, Expression expression) {
        PMMLEncoder encoder = this.ensureEncoder();
        OpType opType = null;
        DataType dataType = ExpressionUtil.getDataType((Expression)expression, (FeatureResolver)this);
        if (dataType != null) {
            opType = TypeUtil.getOpType((DataType)dataType);
        } else {
            opType = OpType.CONTINUOUS;
            dataType = DataType.DOUBLE;
        }
        DefineFunction defineFunction = new DefineFunction(name, opType, dataType, null, expression);
        encoder.addDefineFunction(defineFunction);
        return defineFunction;
    }

    protected DerivedField ensureDerivedField(String name, Expression expression) {
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(name);
        if (derivedField != null) {
            return derivedField;
        }
        OpType opType = null;
        DataType dataType = ExpressionUtil.getDataType((Expression)expression, (FeatureResolver)this);
        if (dataType != null) {
            opType = TypeUtil.getOpType((DataType)dataType);
        } else {
            opType = OpType.CONTINUOUS;
            dataType = DataType.DOUBLE;
        }
        return encoder.createDerivedField(name, opType, dataType, expression);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = Objects.requireNonNull(scope);
    }

    public Map<String, FunctionDef> getFunctionDefs() {
        return this.functionDefs;
    }

    public Map<String, String> getModuleImports() {
        return this.moduleImports;
    }

    public static String toSingleLine(String string) {
        return string.replaceAll("\t", "\\\\t").replaceAll("\n", "\\\\n");
    }
}

