/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class PythonFormatterUtil {
    private PythonFormatterUtil() {
    }

    public static String formatValue(Object value) {
        if (value == null) {
            return "None";
        }
        if (value instanceof Boolean) {
            return PythonFormatterUtil.formatBoolean((Boolean)value);
        }
        if (value instanceof Number) {
            return PythonFormatterUtil.formatNumber((Number)value);
        }
        if (value instanceof String) {
            return PythonFormatterUtil.formatString((String)value);
        }
        throw new IllegalArgumentException();
    }

    public static String formatBoolean(Boolean value) {
        return value != false ? "True" : "False";
    }

    public static String formatNumber(Number value) {
        return value.toString();
    }

    public static String formatString(String value) {
        if (value.contains("\n")) {
            return "'''" + value + "'''";
        }
        return "'" + value + "'";
    }

    public static String formatCollection(Collection<?> values) {
        String endChar;
        String startChar;
        if (values instanceof Set) {
            startChar = "(";
            endChar = ")";
        } else {
            startChar = "[";
            endChar = "]";
        }
        return values.stream().map(value -> PythonFormatterUtil.formatValue(value)).collect(Collectors.joining(", ", startChar, endChar));
    }
}

