/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import org.jpmml.python.ParseException;
import org.jpmml.python.Token;

public class PythonParserUtil {
    private PythonParserUtil() {
    }

    public static String getWhitespace(Token token) {
        Token prevSpecialToken;
        StringBuilder sb = new StringBuilder();
        Token specialToken = token.specialToken;
        if (!PythonParserUtil.isWhitespace(specialToken)) {
            specialToken = null;
        }
        while (specialToken != null && PythonParserUtil.isWhitespace(prevSpecialToken = specialToken.specialToken)) {
            specialToken = prevSpecialToken;
        }
        while (specialToken != null) {
            sb.append(specialToken.image);
            specialToken = specialToken.next;
        }
        return sb.toString();
    }

    private static boolean isWhitespace(Token token) {
        return token != null && token.kind == 1;
    }

    public static String translateBoolean(String image) {
        return image.toLowerCase();
    }

    public static String translateInt(String image) {
        if (image.endsWith("l") || image.endsWith("L")) {
            return image.substring(0, image.length() - 1);
        }
        return image;
    }

    public static String translateString(String image) {
        if (image.startsWith("r") || image.startsWith("R")) {
            return PythonParserUtil.translateRawString(image);
        }
        return PythonParserUtil.translateRegularString(image);
    }

    public static String translateRawString(String image) {
        if (image.length() < 3 || image.charAt(0) != 'r' && image.charAt(0) != 'R' || image.charAt(1) != '\'' && image.charAt(1) != '\"' || image.charAt(1) != image.charAt(image.length() - 1)) {
            throw new IllegalArgumentException(image);
        }
        return image.substring(2, image.length() - 1).replaceAll("\\\\", "\\\\\\\\");
    }

    public static String translateRegularString(String image) {
        if (image.length() < 2 || image.charAt(0) != '\'' && image.charAt(0) != '\"' || image.charAt(0) != image.charAt(image.length() - 1)) {
            throw new IllegalArgumentException(image);
        }
        return image.substring(1, image.length() - 1);
    }

    public static String translateMultilineString(String image) {
        if (!(image.length() >= 6 && (image.startsWith("'''") && image.endsWith("'''") || image.startsWith("\"\"\"") && image.endsWith("\"\"\"")))) {
            throw new IllegalArgumentException(image);
        }
        return image.substring(3, image.length() - 3);
    }

    public static Object parseValue(Token value) throws ParseException {
        switch (value.kind) {
            case 30: {
                return null;
            }
            case 29: 
            case 31: {
                return PythonParserUtil.parseBoolean(value);
            }
            case 41: {
                return PythonParserUtil.parseInt(value);
            }
            case 42: {
                return PythonParserUtil.parseFloat(value);
            }
            case 44: {
                return PythonParserUtil.parseString(value);
            }
            case 45: {
                return PythonParserUtil.parseMultilineString(value);
            }
        }
        throw new ParseException();
    }

    public static boolean parseBoolean(Token value) {
        String image = PythonParserUtil.translateBoolean(value.image);
        return Boolean.parseBoolean(image);
    }

    public static double parseFloat(Token value) {
        return Double.parseDouble(value.image);
    }

    public static int parseInt(Token value) {
        return PythonParserUtil.parseInt(null, value);
    }

    public static int parseInt(Token sign, Token value) {
        Object image = PythonParserUtil.translateInt(value.image);
        if (sign != null) {
            image = sign.image + (String)image;
        }
        return Integer.parseInt((String)image);
    }

    public static String parseString(Token value) {
        return PythonParserUtil.translateString(value.image);
    }

    public static String parseMultilineString(Token value) {
        return PythonParserUtil.translateMultilineString(value.image);
    }
}

