/* PredicateTranslator.java */
/* Generated By:JavaCC: Do not edit this line. PredicateTranslator.java */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;

import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.PMMLFunctions;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;

public class PredicateTranslator extends AbstractTranslator implements PythonParserConstants {

        public PredicateTranslator(Scope scope){
                this(new NullProvider());

                setScope(scope);
        }

        @Override
        public Expression encodeFunction(String dottedName, List<?> arguments){
                Expression expression = super.encodeFunction(dottedName, arguments);

                if(expression instanceof Apply){
                        Apply apply = (Apply)expression;

                        String name = formatApply(apply);

                        ensureDerivedField(name, null, apply);
                }

                return expression;
        }

        public Predicate translatePredicate(String string){
                ReInit(new StringProvider(string));

                Predicate predicate;

                try {
                        predicate = translatePredicateInternal();
                } catch(ParseException pe){
                        throw new TranslationException("Python predicate \'" + string + "\' is either invalid or not supported", pe);
                }

                return predicate;
        }

        static
        private SimplePredicate.Operator translateRelationalOperator(Token operator) throws ParseException {

                switch(operator.kind){
                        case EQUAL:
                                return SimplePredicate.Operator.EQUAL;
                        case NOT_EQUAL:
                                return SimplePredicate.Operator.NOT_EQUAL;
                        case LESS_THAN:
                                return SimplePredicate.Operator.LESS_THAN;
                        case LESS_OR_EQUAL:
                                return SimplePredicate.Operator.LESS_OR_EQUAL;
                        case GREATER_THAN:
                                return SimplePredicate.Operator.GREATER_THAN;
                        case GREATER_OR_EQUAL:
                                return SimplePredicate.Operator.GREATER_OR_EQUAL;
                        default:
                                throw new ParseException();
                }
        }

        static
        private String getOnlyArgument(Apply apply){
                List<Expression> expressions = apply.getExpressions();

                ClassDictUtil.checkSize(1, expressions);

                FieldRef fieldRef = (FieldRef)expressions.get(0);

                return fieldRef.requireField();
        }

        static
        private Array createArray(List<?> values){
                DataType dataType = TypeUtil.getDataType(values, DataType.STRING);

                return PMMLUtil.createArray(dataType, values);
        }

        static
        private SimplePredicate createSimplePredicate(Object left, SimplePredicate.Operator operator, Object right){
                String name = asFieldName(left);
                Object value = (right != null ? asValue(right) : null);

                return new SimplePredicate(name, operator, value);
        }

        static
        private SimpleSetPredicate createSimpleSetPredicate(Object left, SimpleSetPredicate.BooleanOperator booleanOperator, Object right){
                String name = asFieldName(left);
                Array array = (Array)right;

                return new SimpleSetPredicate(name, booleanOperator, array);
        }

        static
        private CompoundPredicate createCompoundPredicate(Predicate left, CompoundPredicate.BooleanOperator booleanOperator, Predicate right){

                if(left instanceof CompoundPredicate){
                        CompoundPredicate compoundPredicate = (CompoundPredicate)left;

                        if(compoundPredicate.requireBooleanOperator() == booleanOperator){
                                compoundPredicate.addPredicates(right);

                                return compoundPredicate;
                        }
                }

                CompoundPredicate compoundPredicate = new CompoundPredicate(booleanOperator, null)
                        .addPredicates(left, right);

                return compoundPredicate;
        }

        static
        private String asFieldName(Object object){

                if(object instanceof Feature){
                        Feature feature = (Feature)object;

                        return feature.getName();
                } // End if

                if(object instanceof Apply){
                        Apply apply = (Apply)object;

                        String name = formatApply(apply);

                        return name;
                } else

                if(object instanceof FieldRef){
                        FieldRef fieldRef = (FieldRef)object;

                        return fieldRef.requireField();
                } // End if

                throw new TranslationException("The left-hand side of the predicate (" + object + ") is not a feature reference");
        }

        static
        private Object asValue(Object object){

                if(object instanceof Boolean){
                        return (Boolean)object;
                } else

                if(object instanceof Integer){
                        return (Integer)object;
                } else

                if(object instanceof Double){
                        return (Double)object;
                } else

                if(object instanceof String){
                        return (String)object;
                }

                throw new TranslationException("The right-hand side of the predicate (" + object + ") is not a value");
        }

        static
        private Predicate asPredicate(Object object){

                if(object instanceof Predicate){
                        Predicate predicate = (Predicate)object;

                        return predicate;
                } // End if

                if(object instanceof Apply){
                        Apply apply = (Apply)object;

                        switch(apply.requireFunction()){
                                case PMMLFunctions.ISMISSING:
                                        return new SimplePredicate(getOnlyArgument(apply), SimplePredicate.Operator.IS_MISSING, null);
                                case PMMLFunctions.ISNOTMISSING:
                                        return new SimplePredicate(getOnlyArgument(apply), SimplePredicate.Operator.IS_NOT_MISSING, null);
                                default:
                                        break;
                        }
                } // End if

                if(object instanceof Feature){
                        Feature feature = (Feature)object;

                        if(feature.getDataType() == DataType.BOOLEAN){
                                return new SimplePredicate(feature.getName(), SimplePredicate.Operator.EQUAL, Boolean.TRUE);
                        }
                } // End if

                if((Boolean.FALSE).equals(object)){
                        return False.INSTANCE;
                } else

                if((Boolean.TRUE).equals(object)){
                        return True.INSTANCE;
                } // End if

                throw new TranslationException("The expression (" + object + ") is not a predicate");
        }

        static
        private Object asArgument(Object object){

                if(object instanceof Feature){
                        Feature feature = (Feature)object;

                        return feature;
                }

                throw new TranslationException("The function argument (" + object + ") is not a feature reference");
        }

        static
        private String formatApply(Apply apply){
                String function = apply.requireFunction();
                List<String> arguments = new ArrayList<>();

                if(apply.hasExpressions()){
                        List<Expression> expressions = apply.getExpressions();

                        for(int i = 0; i < expressions.size(); i++){
                                FieldRef fieldRef = (FieldRef)expressions.get(i);

                                arguments.add(fieldRef.requireField());
                        }
                }

                return FieldNameUtil.create(function, arguments);
        }

  final private Token String() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      token = jj_consume_token(STRING);
      break;
      }
    case MULTILINE_STRING:{
      token = jj_consume_token(MULTILINE_STRING);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private int ColumnIndex() throws ParseException {Token sign = null;
        Token column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    column = jj_consume_token(INT);
return PythonParserUtil.parseInt(sign, column);
}

  final private int ArrayColumnIndex() throws ParseException {int columnIndex;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        columnIndex = ColumnIndex();
        jj_consume_token(RBRACKET);
        break;
        }
      case PLUS:
      case MINUS:
      case INT:{
        columnIndex = ColumnIndex();
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case PLUS:
    case MINUS:
    case INT:{
      columnIndex = ColumnIndex();
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columnIndex;
}

  final private String ColumnName() throws ParseException {Token column;
    column = String();
return PythonParserUtil.parseString(column);
}

  final private String DottedName() throws ParseException {Token name;
        StringBuilder sb = new StringBuilder();
    name = jj_consume_token(NAME);
sb.append(name.image);
    label_1:
    while (true) {
      if (jj_2_1(2147483647)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
sb.append('.').append(name.image);
    }
return sb.toString();
}

  final private String CanonicalizedDottedName() throws ParseException {String dottedName;
    dottedName = DottedName();
return canonicalizeDottedName(dottedName);
}

  final private Predicate translatePredicateInternal() throws ParseException {Predicate predicate;
    predicate = Predicate();
    jj_consume_token(0);
return predicate;
}

  final private Predicate Predicate() throws ParseException {Predicate predicate;
    predicate = LogicalOrExpression();
return predicate;
}

  final private Predicate LogicalOrExpression() throws ParseException {Predicate left;
        Predicate right;
    left = LogicalAndExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = createCompoundPredicate(left, CompoundPredicate.BooleanOperator.OR, right);
    }
return left;
}

  final private Predicate LogicalAndExpression() throws ParseException {Predicate left;
        Predicate right;
    left = ComparisonExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(AND);
      right = ComparisonExpression();
left = createCompoundPredicate(left, CompoundPredicate.BooleanOperator.AND, right);
    }
return left;
}

  final private Predicate ComparisonExpression() throws ParseException {Object left;
        Token operator = null;
        Object right;
    left = PrimaryExpression();
    if (jj_2_2(2147483647)) {
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = createSimplePredicate(left, SimplePredicate.Operator.IS_MISSING, null);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IS:{
        jj_consume_token(IS);
        jj_consume_token(NOT);
        jj_consume_token(NONE);
left = createSimplePredicate(left, SimplePredicate.Operator.IS_NOT_MISSING, null);
        break;
        }
      case IN:{
        jj_consume_token(IN);
        right = ListMakerExpression();
left = createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_IN, right);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        jj_consume_token(IN);
        right = ListMakerExpression();
left = createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, right);
        break;
        }
      case EQUAL:
      case NOT_EQUAL:
      case LESS_THAN:
      case LESS_OR_EQUAL:
      case GREATER_THAN:
      case GREATER_OR_EQUAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:{
          operator = jj_consume_token(EQUAL);
          break;
          }
        case NOT_EQUAL:{
          operator = jj_consume_token(NOT_EQUAL);
          break;
          }
        case LESS_THAN:{
          operator = jj_consume_token(LESS_THAN);
          break;
          }
        case LESS_OR_EQUAL:{
          operator = jj_consume_token(LESS_OR_EQUAL);
          break;
          }
        case GREATER_THAN:{
          operator = jj_consume_token(GREATER_THAN);
          break;
          }
        case GREATER_OR_EQUAL:{
          operator = jj_consume_token(GREATER_OR_EQUAL);
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        right = UnaryExpression();
left = createSimplePredicate(left, translateRelationalOperator(operator), right);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
left = asPredicate(left);
      }
    }
return (Predicate)left;
}

  final private Object UnaryExpression() throws ParseException {Token sign = null;
        Object result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      result = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      result = PrimaryExpression();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        result = ValueUtil.toNegative(asValue(result));
                }

                return result;
}

  final private Object PrimaryExpression() throws ParseException {String dottedName;
        Object result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      dottedName = CanonicalizedDottedName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        result = ArrayIndexingExpression(dottedName);
        break;
        }
      case LPAREN:{
        result = FunctionInvocationExpression(dottedName);
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        result = NameInvocationExpression(dottedName);
      }
      break;
      }
    case LPAREN:{
      result = ParenthesizedExpression();
      break;
      }
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case STRING:
    case MULTILINE_STRING:{
      result = LiteralExpression();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final private Feature ArrayIndexingExpression(String dottedName) throws ParseException {Scope scope = ensureScope();

        int colIndex;
        String colName;

        Feature feature;
    if (jj_2_3(2147483647)) {
      jj_consume_token(LBRACKET);
      colIndex = ArrayColumnIndex();
      jj_consume_token(RBRACKET);
feature = scope.getFeature(dottedName, colIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        colName = ColumnName();
        jj_consume_token(RBRACKET);
feature = scope.getFeature(dottedName, colName);
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return feature;
}

  final private Object FunctionInvocationExpression(String dottedName) throws ParseException {List<Object> arguments;
    arguments = Arguments();
return encodeFunction(dottedName, arguments);
}

  final private List<Object> Arguments() throws ParseException {Object argument;
        List<Object> arguments = new ArrayList<>();
    if (jj_2_4(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        argument = PrimaryExpression();
arguments.add(asArgument(argument));
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            break label_4;
          }
          jj_consume_token(COMMA);
          argument = PrimaryExpression();
arguments.add(asArgument(argument));
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return arguments;
}

  final private Object NameInvocationExpression(String dottedName) throws ParseException {Scope scope = ensureScope();
Feature feature = scope.getFeature(dottedName);

                return feature;
}

  final private Predicate ParenthesizedExpression() throws ParseException {Predicate predicate;
    jj_consume_token(LPAREN);
    predicate = Predicate();
    jj_consume_token(RPAREN);
return predicate;
}

  final private Object LiteralExpression() throws ParseException {Token value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:{
      value = jj_consume_token(FALSE);
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
      break;
      }
    case STRING:
    case MULTILINE_STRING:{
      value = String();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return PythonParserUtil.parseValue(value);
}

  final private Array ListMakerExpression() throws ParseException {Object predicate;

        List<Object> values = new ArrayList<Object>();
    jj_consume_token(LBRACKET);
    predicate = UnaryExpression();
values.add(asValue(predicate));
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      predicate = UnaryExpression();
values.add(asValue(predicate));
    }
    jj_consume_token(RBRACKET);
return createArray(values);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_3R_Sign_473_9_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_ColumnIndex_490_10_12()
 {
    if (jj_3R_Sign_473_9_13()) return true;
    return false;
  }

  private boolean jj_3R_ColumnIndex_490_9_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnIndex_490_10_12()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_505_17_8()
 {
    if (jj_3R_ColumnIndex_490_9_11()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_503_86_10()
 {
    if (jj_3R_ColumnIndex_490_9_11()) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_503_17_7()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayColumnIndex_503_34_9()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayColumnIndex_503_86_10()) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_503_34_9()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ColumnIndex_490_9_11()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_ArrayColumnIndex_502_9_6()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayColumnIndex_503_17_7()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayColumnIndex_505_17_8()) return true;
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ArrayColumnIndex_502_9_6()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[17];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x30000,0x30000,0x830000,0x8030000,0x40,0x80,0x7e00,0x7f00,0xa0030010,0x800010,0xa0000010,0x800000,0x2000000,0x10,0xa0000000,0x2000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x6000,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0xc0,0x7c00,0x0,0x7c00,0x0,0x0,0x0,0x6c00,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public PredicateTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PythonParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 17; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PredicateTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PythonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 17; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PredicateTranslator(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 17; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 17; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[51];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 17; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 51; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : PythonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 4; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
