/*
 * Decompiled with CFR 0.152.
 */
package scipy.sparse;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jpmml.converter.ValueUtil;
import scipy.sparse.CSRMatrix;

public class CSRMatrixUtil {
    private static final Integer ZERO = 0;

    private CSRMatrixUtil() {
    }

    public static int[] getShape(CSRMatrix matrix) {
        Object[] shape = matrix.getShape();
        if (shape.length == 1) {
            return new int[]{ValueUtil.asInt((Number)((Number)shape[0]))};
        }
        if (shape.length == 2) {
            return new int[]{ValueUtil.asInt((Number)((Number)shape[0])), ValueUtil.asInt((Number)((Number)shape[1]))};
        }
        List<Object> values = Arrays.asList(shape);
        return Ints.toArray((Collection)ValueUtil.asIntegers(values));
    }

    public static List<? extends Number> getContent(CSRMatrix matrix) {
        int[] shape = CSRMatrixUtil.getShape(matrix);
        int numberOfRows = shape[0];
        int numberOfColumns = shape[1];
        ArrayList<Number> result = new ArrayList<Number>(numberOfRows * numberOfColumns);
        List<Object> data = matrix.getData();
        List<Integer> indices = matrix.getIndices();
        List<Integer> indPtr = matrix.getIndPtr();
        for (int row = 0; row < numberOfRows; ++row) {
            int offset = result.size();
            for (int column = 0; column < numberOfColumns; ++column) {
                result.add(ZERO);
            }
            int begin = indPtr.get(row);
            int end = indPtr.get(row + 1);
            for (int i = begin; i < end; ++i) {
                int index = indices.get(i);
                if (index < numberOfColumns) {
                    index = offset + index;
                }
                result.set(index, (Number)data.get(i));
            }
        }
        return result;
    }
}

