/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedInts;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import numpy.DType;
import numpy.core.Complex;
import numpy.core.NDArrayUtil;
import org.dmg.pmml.DataType;
import org.jpmml.python.CalendarUtil;

public class TypeDescriptor {
    private String descr = null;
    private ByteOrder byteOrder = null;
    private Kind kind = null;
    private int size = 0;
    private Object[] datetimeData = null;
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    public TypeDescriptor(Object descr) {
        if (descr instanceof String) {
            String string = (String)descr;
            this.parseDescr(string);
        } else if (descr instanceof DType) {
            DType dtype = (DType)descr;
            String string = (String)dtype.toDescr();
            this.parseDescr(string);
            Object[] datetimeData = dtype.getDatetimeData();
            if (datetimeData != null) {
                this.setDatetimeData(datetimeData);
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(descr));
        }
    }

    private void parseDescr(String descr) {
        this.setDescr(descr);
        int i = 0;
        ByteOrder byteOrder = null;
        switch (descr.charAt(i)) {
            case '=': {
                byteOrder = ByteOrder.nativeOrder();
                ++i;
                break;
            }
            case '>': {
                byteOrder = ByteOrder.BIG_ENDIAN;
                ++i;
                break;
            }
            case '<': {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                ++i;
                break;
            }
            case '|': {
                ++i;
            }
        }
        this.setByteOrder(byteOrder);
        Kind kind = Kind.forChar(descr.charAt(i));
        this.setKind(kind);
        if (++i < descr.length()) {
            int size = Integer.parseInt(descr.substring(i));
            this.setSize(size);
        }
    }

    public DataType getDataType() {
        String descr = this.getDescr();
        Kind kind = this.getKind();
        int size = this.getSize();
        switch (kind) {
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case INTEGER: 
            case UNSIGNED_INTEGER: {
                return DataType.INTEGER;
            }
            case FLOAT: {
                switch (size) {
                    case 4: {
                        return DataType.FLOAT;
                    }
                    case 8: {
                        return DataType.DOUBLE;
                    }
                }
                throw new IllegalArgumentException(descr);
            }
            case COMPLEX_FLOAT: {
                switch (size) {
                    case 8: {
                        return DataType.FLOAT;
                    }
                    case 16: {
                        return DataType.DOUBLE;
                    }
                }
                throw new IllegalArgumentException(descr);
            }
            case DATETIME: {
                switch (size) {
                    case 8: {
                        String datetimeUnit;
                        switch (datetimeUnit = this.getDatetimeUnit()) {
                            case "Y": 
                            case "M": 
                            case "D": {
                                return DataType.DATE;
                            }
                            case "h": 
                            case "m": 
                            case "s": {
                                return DataType.DATE_TIME;
                            }
                            case "ms": 
                            case "us": 
                            case "ns": {
                                return DataType.DATE_TIME;
                            }
                        }
                        throw new IllegalArgumentException(datetimeUnit);
                    }
                }
                throw new IllegalArgumentException(descr);
            }
            case OBJECT: {
                return DataType.STRING;
            }
            case STRING: 
            case UNICODE: {
                return DataType.STRING;
            }
        }
        throw new IllegalArgumentException(descr);
    }

    public Object read(InputStream is) throws IOException {
        String descr = this.getDescr();
        Kind kind = this.getKind();
        ByteOrder byteOrder = this.getByteOrder();
        int size = this.getSize();
        switch (kind) {
            case BOOLEAN: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readByte(is) == 1;
                    }
                }
                break;
            }
            case INTEGER: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readByte(is);
                    }
                    case 2: {
                        return NDArrayUtil.readShort(is, byteOrder);
                    }
                    case 4: {
                        return NDArrayUtil.readInt(is, byteOrder);
                    }
                    case 8: {
                        return NDArrayUtil.readLong(is, byteOrder);
                    }
                }
                break;
            }
            case UNSIGNED_INTEGER: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readUnsignedByte(is);
                    }
                    case 2: {
                        return NDArrayUtil.readUnsignedShort(is, byteOrder);
                    }
                    case 4: {
                        return UnsignedInts.toLong((int)NDArrayUtil.readInt(is, byteOrder));
                    }
                    case 8: {
                        String string = Long.toUnsignedString(NDArrayUtil.readLong(is, byteOrder));
                        return Long.parseUnsignedLong(string);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (size) {
                    case 4: {
                        return Float.valueOf(NDArrayUtil.readFloat(is, byteOrder));
                    }
                    case 8: {
                        return NDArrayUtil.readDouble(is, byteOrder);
                    }
                }
                break;
            }
            case COMPLEX_FLOAT: {
                switch (size) {
                    case 8: {
                        float real = NDArrayUtil.readFloat(is, byteOrder);
                        float imaginary = NDArrayUtil.readFloat(is, byteOrder);
                        return new Complex(Float.valueOf(real), Float.valueOf(imaginary));
                    }
                    case 16: {
                        double real = NDArrayUtil.readDouble(is, byteOrder);
                        double imaginary = NDArrayUtil.readDouble(is, byteOrder);
                        return new Complex(real, imaginary);
                    }
                }
                break;
            }
            case DATETIME: {
                String datetimeUnit = this.getDatetimeUnit();
                switch (size) {
                    case 8: {
                        long value = NDArrayUtil.readLong(is, byteOrder);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeZone(TIMEZONE_UTC);
                        switch (datetimeUnit) {
                            case "Y": 
                            case "M": 
                            case "D": {
                                long millis;
                                switch (datetimeUnit) {
                                    case "D": {
                                        millis = TimeUnit.DAYS.toMillis(value);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException(datetimeUnit);
                                    }
                                }
                                calendar.setTimeInMillis(millis);
                                return CalendarUtil.toLocalDate(calendar);
                            }
                            case "h": 
                            case "m": 
                            case "s": 
                            case "ms": 
                            case "us": 
                            case "ns": {
                                long millis;
                                switch (datetimeUnit) {
                                    case "h": {
                                        millis = TimeUnit.HOURS.toMillis(value);
                                        break;
                                    }
                                    case "m": {
                                        millis = TimeUnit.MINUTES.toMillis(value);
                                        break;
                                    }
                                    case "s": {
                                        millis = TimeUnit.SECONDS.toMillis(value);
                                        break;
                                    }
                                    case "ms": {
                                        millis = TimeUnit.MILLISECONDS.toMillis(value);
                                        break;
                                    }
                                    case "us": {
                                        millis = TimeUnit.MICROSECONDS.toMillis(value);
                                        break;
                                    }
                                    case "ns": {
                                        millis = TimeUnit.NANOSECONDS.toMillis(value);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException(datetimeUnit);
                                    }
                                }
                                calendar.setTimeInMillis(millis);
                                return CalendarUtil.toLocalDateTime(calendar);
                            }
                        }
                        throw new IllegalArgumentException(datetimeUnit);
                    }
                }
                break;
            }
            case OBJECT: {
                return NDArrayUtil.readObject(is);
            }
            case STRING: {
                return NDArrayUtil.readString(is, size);
            }
            case UNICODE: {
                return NDArrayUtil.readUnicode(is, byteOrder, size);
            }
            case VOID: {
                byte[] buffer = new byte[size];
                ByteStreams.readFully((InputStream)is, (byte[])buffer);
                return buffer;
            }
        }
        throw new IllegalArgumentException(descr);
    }

    public boolean isObject() {
        Kind kind = this.getKind();
        switch (kind) {
            case OBJECT: {
                return true;
            }
        }
        return false;
    }

    public String getDatetimeUnit() {
        Object[] datetimeData = this.getDatetimeData();
        if (datetimeData == null) {
            throw new IllegalStateException();
        }
        Object units = ((Object[])datetimeData[1])[0];
        if (units instanceof String) {
            String string = (String)units;
            return string;
        }
        if (units instanceof byte[]) {
            byte[] bytes = (byte[])units;
            return new String(bytes);
        }
        throw new IllegalArgumentException(String.valueOf(units));
    }

    public String getDescr() {
        return this.descr;
    }

    private void setDescr(String descr) {
        this.descr = descr;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public Kind getKind() {
        return this.kind;
    }

    private void setKind(Kind kind) {
        this.kind = kind;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public Object[] getDatetimeData() {
        return this.datetimeData;
    }

    private void setDatetimeData(Object[] datetimeData) {
        this.datetimeData = datetimeData;
    }

    public static enum Kind {
        BOOLEAN,
        INTEGER,
        UNSIGNED_INTEGER,
        FLOAT,
        COMPLEX_FLOAT,
        TIMEDELTA,
        DATETIME,
        OBJECT,
        STRING,
        UNICODE,
        VOID;


        public static Kind forChar(char c) {
            switch (c) {
                case 'b': {
                    return BOOLEAN;
                }
                case 'i': {
                    return INTEGER;
                }
                case 'u': {
                    return UNSIGNED_INTEGER;
                }
                case 'f': {
                    return FLOAT;
                }
                case 'c': {
                    return COMPLEX_FLOAT;
                }
                case 'm': {
                    return TIMEDELTA;
                }
                case 'M': {
                    return DATETIME;
                }
                case 'O': {
                    return OBJECT;
                }
                case 'S': 
                case 'a': {
                    return STRING;
                }
                case 'U': {
                    return UNICODE;
                }
                case 'V': {
                    return VOID;
                }
            }
            throw new IllegalArgumentException(String.valueOf(c));
        }
    }
}

