/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rattle.visitors;

import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ExtensionUtil;
import org.jpmml.model.visitors.PredicateFilterer;

public class PredicateTransformer
extends PredicateFilterer {
    public Predicate filter(Predicate predicate) {
        if (predicate == null || ExtensionUtil.hasExtensions((PMMLObject)predicate)) {
            return predicate;
        }
        return this.transform(predicate);
    }

    public Predicate transform(Predicate predicate) {
        if (predicate instanceof SimpleSetPredicate) {
            return this.transform((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof CompoundPredicate) {
            return this.transform((CompoundPredicate)predicate);
        }
        return predicate;
    }

    private Predicate transform(SimpleSetPredicate simpleSetPredicate) {
        Array array = simpleSetPredicate.getArray();
        List content = ArrayUtil.getContent((Array)array);
        if (content.size() != 1) {
            return simpleSetPredicate;
        }
        String value = (String)content.get(0);
        SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.getBooleanOperator();
        switch (booleanOperator) {
            case IS_IN: {
                return PredicateTransformer.createSimplePredicate(simpleSetPredicate.getField(), SimplePredicate.Operator.EQUAL, value);
            }
            case IS_NOT_IN: {
                return PredicateTransformer.createSimplePredicate(simpleSetPredicate.getField(), SimplePredicate.Operator.NOT_EQUAL, value);
            }
        }
        return simpleSetPredicate;
    }

    private Predicate transform(CompoundPredicate compoundPredicate) {
        List predicates = compoundPredicate.getPredicates();
        CompoundPredicate.BooleanOperator booleanOperator = compoundPredicate.getBooleanOperator();
        switch (booleanOperator) {
            case SURROGATE: {
                return this.transform((Predicate)predicates.get(0));
            }
        }
        return compoundPredicate;
    }

    private static SimplePredicate createSimplePredicate(FieldName field, SimplePredicate.Operator operator, String value) {
        SimplePredicate simplePredicate = new SimplePredicate(field, operator).setValue(value);
        return simplePredicate;
    }
}

