/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.example;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--model-rds-input", "--rds-input"}, description="RDS input file", required=true, order=1)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true, order=2)
    private File output = null;
    @Parameter(names={"--converter"}, description="Converter class", order=3)
    private String converter = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true, order=0x7FFFFFFF)
    private boolean help = false;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        DefaultUsageFormatter usageFormatter = new DefaultUsageFormatter(commander);
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            usageFormatter.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            usageFormatter.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        Converter converter;
        RExp rexp;
        try (FileInputStream is = new FileInputStream(this.input);){
            logger.info("Parsing RDS..");
            RExpParser parser = new RExpParser((InputStream)is);
            long begin = System.currentTimeMillis();
            rexp = parser.parse();
            long end = System.currentTimeMillis();
            logger.info("Parsed RDS in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse RDS", (Throwable)e);
            throw e;
        }
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        if (this.converter != null) {
            logger.info("Initializing user-specified Converter {}", (Object)this.converter);
            Class<?> clazz = Class.forName(this.converter);
            converter = converterFactory.newConverter(clazz, rexp);
        } else {
            logger.info("Initializing default Converter");
            converter = converterFactory.newConverter(rexp);
        }
        Class<?> clazz = converter.getClass();
        logger.info("Initialized {}", (Object)clazz.getName());
        try {
            logger.info("Converting RDS to PMML..");
            long begin = System.currentTimeMillis();
            pmml = converter.encodePMML();
            long end = System.currentTimeMillis();
            logger.info("Converted RDS to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert RDS to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            long begin = System.currentTimeMillis();
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            long end = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        if (output == null) {
            throw new NullPointerException();
        }
        this.output = output;
    }
}

