/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.runtime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.PMMLManager;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ModelManagerCache {
    private ModelManagerFactory modelManagerFactory = null;
    private LoadingCache<URI, ModelManager<? extends Model>> cache = null;

    public ModelManagerCache(ModelManagerFactory modelManagerFactory, CacheBuilder<Object, Object> cacheBuilder) {
        this.setModelEvaluatorFactory(modelManagerFactory);
        CacheLoader<URI, ModelManager<? extends Model>> cacheLoader = new CacheLoader<URI, ModelManager<? extends Model>>(){

            public ModelManager<? extends Model> load(URI uri) throws Exception {
                return ModelManagerCache.this.loadModelManager(uri);
            }
        };
        this.cache = cacheBuilder.build((CacheLoader)cacheLoader);
    }

    public ModelManager<? extends Model> get(Class<?> clazz) throws Exception {
        return this.get(ModelManagerCache.toURL(clazz));
    }

    public ModelManager<? extends Model> get(URL url) throws Exception {
        URI uri = url.toURI();
        return (ModelManager)this.cache.get((Object)uri);
    }

    public void remove(Class<?> clazz) throws Exception {
        this.remove(ModelManagerCache.toURL(clazz));
    }

    public void remove(URL url) throws Exception {
        URI uri = url.toURI();
        this.cache.invalidate((Object)uri);
    }

    public ConcurrentMap<URI, ModelManager<? extends Model>> asMap() {
        return this.cache.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelManager<? extends Model> loadModelManager(URI uri) throws IOException, JAXBException, SAXException {
        PMML pmml;
        URL url = uri.toURL();
        InputStream is = url.openStream();
        try {
            InputSource source = new InputSource(is);
            SAXSource transformedSource = ImportFilter.apply((InputSource)source);
            pmml = JAXBUtil.unmarshalPMML((Source)transformedSource);
        }
        finally {
            is.close();
        }
        pmml = this.process(pmml);
        PMMLManager pmmlManager = new PMMLManager(pmml);
        ModelManagerFactory modelManagerFactory = this.getModelManagerFactory();
        return pmmlManager.getModelManager(modelManagerFactory);
    }

    protected PMML process(PMML pmml) {
        return pmml;
    }

    public ModelManagerFactory getModelManagerFactory() {
        return this.modelManagerFactory;
    }

    private void setModelEvaluatorFactory(ModelManagerFactory modelManagerFactory) {
        this.modelManagerFactory = modelManagerFactory;
    }

    private static URL toURL(Class<?> clazz) throws IOException {
        String path = clazz.getName().replace('.', '/') + ".pmml";
        ClassLoader clazzLoader = clazz.getClassLoader();
        URL url = clazzLoader.getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }
}

