/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.runtime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.PMMLManager;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ModelManagerCache {
    private ModelManagerFactory modelManagerFactory = null;
    private LoadingCache<Class<?>, ModelManager<? extends Model>> cache = null;

    public ModelManagerCache(ModelManagerFactory modelManagerFactory, CacheBuilder<Object, Object> cacheBuilder) {
        this.setModelEvaluatorFactory(modelManagerFactory);
        CacheLoader cacheLoader = new CacheLoader<Class<?>, ModelManager<? extends Model>>(){

            public ModelManager<? extends Model> load(Class<?> clazz) throws Exception {
                return ModelManagerCache.this.loadModelManager(clazz);
            }
        };
        this.cache = cacheBuilder.build(cacheLoader);
    }

    public ModelManager<? extends Model> get(Class<?> clazz) throws Exception {
        return (ModelManager)this.cache.get(clazz);
    }

    public void remove(Class<?> clazz) {
        this.cache.invalidate(clazz);
    }

    public ConcurrentMap<Class<?>, ModelManager<? extends Model>> asMap() {
        return this.cache.asMap();
    }

    protected PMML process(PMML pmml) {
        return pmml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelManager<? extends Model> loadModelManager(Class<?> clazz) throws IOException, JAXBException, SAXException {
        PMML pmml;
        String path = clazz.getName().replace('.', '/') + ".pmml";
        ClassLoader clazzLoader = clazz.getClassLoader();
        InputStream is = clazzLoader.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(path);
        }
        try {
            InputSource source = new InputSource(is);
            SAXSource transformedSource = ImportFilter.apply((InputSource)source);
            pmml = JAXBUtil.unmarshalPMML((Source)transformedSource);
        }
        finally {
            is.close();
        }
        pmml = this.process(pmml);
        PMMLManager pmmlManager = new PMMLManager(pmml);
        ModelManagerFactory modelManagerFactory = this.getModelManagerFactory();
        return pmmlManager.getModelManager(modelManagerFactory);
    }

    public ModelManagerFactory getModelManagerFactory() {
        return this.modelManagerFactory;
    }

    private void setModelEvaluatorFactory(ModelManagerFactory modelManagerFactory) {
        this.modelManagerFactory = modelManagerFactory;
    }
}

