/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sas.functions;

import com.google.common.base.CharMatcher;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.functions.AbstractFunction;

public class StringNormalize
extends AbstractFunction {
    public StringNormalize() {
        super("SAS-EM-String-Normalize");
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkArguments(arguments, 2);
        int length = arguments.get(0).asInteger();
        if (length < 0) {
            throw new FunctionException((Function)this, "Invalid length value " + length);
        }
        String string = arguments.get(1).asString();
        string = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)string);
        string = string.substring(0, Math.min(length, string.length()));
        string = string.toUpperCase();
        return FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)string);
    }
}

