/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sas.functions;

import java.util.Arrays;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.functions.BinaryFunction;

public class StringNormalize
extends BinaryFunction {
    public StringNormalize() {
        super("SAS-EM-String-Normalize", Arrays.asList("length", null));
    }

    public String evaluate(int length, String string) {
        char c;
        if (length < 0) {
            throw new FunctionException((Function)this, "Invalid \"length\" value " + length);
        }
        int offset = 0;
        for (int i = 0; i < string.length() && (c = string.charAt(i)) <= ' '; ++i) {
            ++offset;
        }
        string = string.substring(offset, offset + Math.min(length, string.length() - offset));
        string = string.toUpperCase();
        return string;
    }

    public FieldValue evaluate(FieldValue first, FieldValue second) {
        String result = this.evaluate(first.asInteger(), second.asString());
        return FieldValueUtil.create((TypeInfo)TypeInfos.CATEGORICAL_STRING, (Object)result);
    }
}

