/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sas.functions;

import java.util.List;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.functions.AbstractFunction;

public class StringNormalize
extends AbstractFunction {
    public StringNormalize() {
        super("SAS-EM-String-Normalize");
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        char c;
        this.checkFixedArityArguments(arguments, 2);
        int length = this.getRequiredArgument(arguments, 0, "length").asInteger();
        if (length < 0) {
            throw new FunctionException((Function)this, "Invalid 'length' value " + length);
        }
        String string = this.getRequiredArgument(arguments, 1).asString();
        int offset = 0;
        for (int i = 0; i < string.length() && (c = string.charAt(i)) <= ' '; ++i) {
            ++offset;
        }
        string = string.substring(offset, offset + Math.min(length, string.length() - offset));
        string = string.toUpperCase();
        return FieldValueUtil.create((TypeInfo)TypeInfos.CATEGORICAL_STRING, (Object)string);
    }
}

