/*
 * Decompiled with CFR 0.152.
 */
package tpot.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.TypeUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasEstimator;
import sklearn.Transformer;

public class StackingEstimator
extends Transformer
implements HasEstimator<Estimator> {
    public StackingEstimator(String module, String name) {
        super(module, name);
    }

    public int getNumberOfFeatures() {
        Estimator estimator = this.getEstimator();
        return estimator.getNumberOfFeatures();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        ContinuousLabel label;
        Estimator estimator = this.getEstimator();
        MiningFunction miningFunction = estimator.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                List categories = EstimatorUtil.getClasses((Estimator)estimator);
                DataType dataType = TypeUtil.getDataType((Collection)categories, (DataType)DataType.STRING);
                label = new CategoricalLabel(dataType, categories);
                break;
            }
            case REGRESSION: {
                label = new ContinuousLabel(DataType.DOUBLE);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Schema schema = new Schema((PMMLEncoder)encoder, (Label)label, features);
        Model model = estimator.encode(schema);
        encoder.addTransformer(model);
        String name = this.createFieldName("stack", features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        switch (miningFunction) {
            case CLASSIFICATION: {
                Classifier classifier = (Classifier)estimator;
                List categories = EstimatorUtil.getClasses((Estimator)estimator);
                OutputField predictedOutputField = ModelUtil.createPredictedField((String)name, (OpType)OpType.CATEGORICAL, (DataType)label.getDataType());
                DerivedOutputField predictedField = encoder.createDerivedField(model, predictedOutputField, false);
                result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)predictedField, categories));
                if (!classifier.hasProbabilityDistribution()) break;
                for (Object category : categories) {
                    OutputField probabilityOutputField = ModelUtil.createProbabilityField((String)FieldNameUtil.create((String)"probability", (Object[])new Object[]{name, category}), (DataType)DataType.DOUBLE, category).setFinalResult(Boolean.valueOf(false));
                    DerivedOutputField probabilityField = encoder.createDerivedField(model, probabilityOutputField, false);
                    result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)probabilityField));
                }
                break;
            }
            case REGRESSION: {
                OutputField predictedOutputField = ModelUtil.createPredictedField((String)name, (OpType)OpType.CONTINUOUS, (DataType)label.getDataType());
                DerivedOutputField predictedField = encoder.createDerivedField(model, predictedOutputField, false);
                result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)predictedField));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        result.addAll(features);
        return result;
    }

    public Estimator getEstimator() {
        return (Estimator)this.get("estimator", Estimator.class);
    }
}

