/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import optbinning.Binning;
import org.jpmml.python.ClassDictUtil;

public class OptimalBinning
extends Binning {
    public OptimalBinning(String module, String name) {
        super(module, name);
    }

    public List<Double> getCategories() {
        List<Integer> numberOfEvents = this.getNumberOfEvents();
        List<Integer> numberOfNonEvents = this.getNumberOfNonEvents();
        ClassDictUtil.checkSize((Collection[])new Collection[]{numberOfEvents, numberOfNonEvents});
        double constant = Math.log((double)OptimalBinning.sum(numberOfEvents) / (double)OptimalBinning.sum(numberOfNonEvents));
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < numberOfEvents.size(); ++i) {
            double eventRate = (double)numberOfEvents.get(i).intValue() / (double)Math.addExact(numberOfEvents.get(i), numberOfNonEvents.get(i));
            double woe = Math.log(1.0 / eventRate - 1.0) + constant;
            result.add(woe);
        }
        return result;
    }

    public List<Integer> getNumberOfEvents() {
        return this.getIntegerArray("_n_event");
    }

    public List<Integer> getNumberOfNonEvents() {
        return this.getIntegerArray("_n_nonevent");
    }
}

