/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.Value;
import org.jpmml.converter.Feature;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import pycaret.preprocess.TransformerWrapper;
import sklearn.InitializerUtil;
import sklearn.preprocessing.LabelEncoder;
import sklearn2pmml.decoration.DomainUtil;

public class TransformerWrapperWithInverse
extends TransformerWrapper {
    public TransformerWrapperWithInverse(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        int labelIndex;
        List<String> featureNamesIn = this.getFeatureNamesIn();
        LabelEncoder transformer = this.getTransformer();
        if (!features.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = InitializerUtil.selectFeatures(featureNamesIn, Collections.emptyList(), (SkLearnEncoder)encoder);
        Feature labelFeature = (Feature)result.get(labelIndex = result.size() - 1);
        if (!(labelFeature instanceof WildcardFeature)) {
            throw new IllegalArgumentException();
        }
        WildcardFeature wildcardFeature = (WildcardFeature)labelFeature;
        DataField dataField = wildcardFeature.getField();
        DomainUtil.clearValues((Field)dataField, (Value.Property)Value.Property.VALID);
        Feature transformedLabelFeature = (Feature)Iterables.getOnlyElement((Iterable)transformer.encode(Collections.singletonList(labelFeature), encoder));
        result = new ArrayList<Feature>(result);
        result.set(labelIndex, transformedLabelFeature);
        return result;
    }

    public LabelEncoder getTransformer() {
        return (LabelEncoder)this.get("transformer", LabelEncoder.class);
    }
}

