/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.CategoryEncoder;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonObject;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.Series;
import pandas.core.SeriesUtil;
import sklearn.Transformer;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends CategoryEncoder {
    public static final Object CATEGORY_UNKNOWN = -1;

    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        List<Mapping> mappings = this.getMapping();
        if (dropInvariant.booleanValue()) {
            throw new IllegalArgumentException();
        }
        switch (handleMissing) {
            case "error": 
            case "return_nan": 
            case "value": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleMissing);
            }
        }
        switch (handleUnknown) {
            case "error": 
            case "value": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleUnknown);
            }
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, mappings});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Mapping mapping = mappings.get(i);
            Map<?, Integer> categoryMappings = mapping.getCategoryMapping();
            ArrayList categories = new ArrayList();
            categories.addAll(categoryMappings.keySet());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            indices.addAll(categoryMappings.values());
            Integer defaultValue = null;
            switch (handleUnknown) {
                case "value": {
                    defaultValue = -2;
                    break;
                }
            }
            result.add(EncoderUtil.encodeIndexFeature((Transformer)this, (Feature)feature, categories, indices, null, (Number)defaultValue, (DataType)DataType.INTEGER, (SkLearnEncoder)encoder));
        }
        return result;
    }

    public List<Mapping> getMapping() {
        List mapping = this.getList("mapping", Map.class);
        Function function = new Function<Map<String, ?>, Mapping>(){

            public Mapping apply(Map<String, ?> map) {
                Mapping mapping = new Mapping(OrdinalEncoder.this.getClassName(), "mapping");
                mapping.putAll(map);
                return mapping;
            }
        };
        return Lists.transform((List)mapping, (Function)function);
    }

    public static class Mapping
    extends PythonObject {
        private Mapping(String module, String name) {
            super(module, name);
        }

        public Map<?, Integer> getCategoryMapping() {
            try {
                Series mapping = (Series)this.get("mapping", Series.class);
                return SeriesUtil.toMap((Series)mapping, (Function)Functions.identity(), ValueUtil::asInteger);
            }
            catch (IllegalArgumentException iae) {
                return (Map)this.get("mapping", Map.class);
            }
        }
    }
}

