/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.Field;
import org.jpmml.converter.Feature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;
import sklearn.InitializerUtil;
import sklearn.Selector;
import sklearn.Transformer;

public class TransformerWrapper
extends Initializer {
    public TransformerWrapper(String module, String name) {
        super(module, name);
    }

    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        return this.encodeFeatures(Collections.emptyList(), encoder);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<String> featureNamesIn = this.getFeatureNamesIn();
        List<String> include = this.getInclude();
        Transformer transformer = this.getTransformer();
        if (features.isEmpty()) {
            features = InitializerUtil.selectFeatures(featureNamesIn, features, (SkLearnEncoder)encoder);
        }
        ArrayList<Feature> includeFeatures = new ArrayList<Feature>();
        for (int i = 0; i < include.size(); ++i) {
            Feature includeFeature;
            String includeColumn = include.get(i);
            if (!features.isEmpty()) {
                int index = featureNamesIn.indexOf(includeColumn);
                includeFeature = (Feature)features.get(index);
            } else {
                includeFeature = InitializerUtil.selectFeature((String)includeColumn, (List)features, (SkLearnEncoder)encoder);
            }
            includeFeatures.add(includeFeature);
        }
        List transformedIncludeFeatures = transformer.encode(includeFeatures, encoder);
        if (transformer instanceof Selector) {
            Selector selector = (Selector)transformer;
            return transformedIncludeFeatures;
        }
        List<List<Feature>> transformedIncludeFeatureGroups = TransformerWrapper.groupByField(transformedIncludeFeatures);
        ClassDictUtil.checkSize((Collection[])new Collection[]{includeFeatures, transformedIncludeFeatureGroups});
        ArrayList<List<Feature>> result = new ArrayList<List<Feature>>(features);
        for (int i = 0; i < include.size(); ++i) {
            String includeColumn = include.get(i);
            int index = featureNamesIn.indexOf(includeColumn);
            List<Feature> transformedIncludeFeatureGroup = transformedIncludeFeatureGroups.get(i);
            result.set(index, transformedIncludeFeatureGroup);
        }
        return result.stream().flatMap(element -> {
            if (element instanceof List) {
                List featureGroup = (List)element;
                return featureGroup.stream();
            }
            Feature feature = (Feature)element;
            return Stream.of(feature);
        }).collect(Collectors.toList());
    }

    public List<String> getFeatureNamesIn() {
        return this.getList("_feature_names_in", String.class);
    }

    public List<String> getExclude() {
        return this.getList("_exclude", String.class);
    }

    public List<String> getInclude() {
        return this.getList("_include", String.class);
    }

    public Transformer getTransformer() {
        return (Transformer)this.get("transformer", Transformer.class);
    }

    private static List<List<Feature>> groupByField(List<Feature> features) {
        ArrayList<List<Feature>> result = new ArrayList<List<Feature>>();
        Field prevField = null;
        ArrayList<Feature> fieldFeatures = null;
        for (Feature feature : features) {
            Field field = feature.getField();
            if (!Objects.equals(field, prevField)) {
                fieldFeatures = new ArrayList<Feature>();
                fieldFeatures.add(feature);
                result.add(fieldFeatures);
            } else {
                fieldFeatures.add(feature);
            }
            prevField = field;
        }
        return result;
    }
}

