/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import optbinning.BinnedFeature;
import optbinning.OptimalBinningUtil;
import org.dmg.pmml.Apply;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class OptimalBinning
extends Transformer {
    public static final Double CATEGORY_MISSING = 0.0;
    public static final Double CATEGORY_SPECIAL = 0.0;

    public OptimalBinning(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Discretize expression;
        String dtype = this.getDType();
        List<Number> specialCodes = this.getSpecialCodes();
        List<Number> splits = this.getSplitsOptimal();
        switch (dtype) {
            case "numerical": 
            case "categorical": {
                break;
            }
            default: {
                throw new IllegalArgumentException(dtype);
            }
        }
        List<Double> categoriesOut = this.getCategoriesOut();
        ClassDictUtil.checkSize((int)(splits.size() + 3), (Collection[])new Collection[]{categoriesOut});
        categoriesOut = categoriesOut.subList(0, categoriesOut.size() - 2);
        SchemaUtil.checkSize((int)1, features);
        Object feature = features.get(0);
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!splits.isEmpty()) {
            OptimalBinningUtil.checkIncreasingOrder(splits);
            switch (dtype) {
                case "numerical": {
                    expression = this.encodeNumericalBinning((Feature)feature, splits, categoriesOut, predicateManager, (List<Predicate>)predicates);
                    break;
                }
                case "categorical": {
                    List<?> categoriesIn = this.getCategoriesIn();
                    if (feature instanceof WildcardFeature) {
                        WildcardFeature wildcardFeature = (WildcardFeature)feature;
                        DataType dataType = TypeUtil.getDataType(categoriesIn, (DataType)DataType.STRING);
                        DataField dataField = wildcardFeature.getField();
                        if (dataField.requireDataType() != dataType) {
                            dataField.setDataType(dataType);
                        }
                        feature = wildcardFeature.toCategoricalFeature(categoriesIn);
                    }
                    expression = this.encodeCategoricalBinning((Feature)feature, splits, categoriesIn, categoriesOut, predicateManager, (List<Predicate>)predicates);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dtype);
                }
            }
        } else {
            Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{feature.ref()}), PMMLUtil.createConstant((Object)categoriesOut.get(0), null), PMMLUtil.createConstant((Number)CATEGORY_MISSING)});
            expression = apply;
        }
        List<Object> categories = categoriesOut.stream().distinct().collect(Collectors.toList());
        if (!specialCodes.isEmpty()) {
            Apply valueApply = PMMLUtil.createApply((String)(specialCodes.size() == 1 ? "equal" : "isIn"), (Expression[])new Expression[]{feature.ref()});
            for (Number specialCode : specialCodes) {
                valueApply.addExpressions(new Expression[]{PMMLUtil.createConstant((Number)specialCode)});
            }
            if (expression instanceof HasMapMissingTo) {
                HasMapMissingTo hasMapMissingTo = (HasMapMissingTo)expression;
                valueApply.setMapMissingTo(hasMapMissingTo.getMapMissingTo());
            }
            Apply ifApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{valueApply, PMMLUtil.createConstant((Number)CATEGORY_SPECIAL), expression});
            expression = ifApply;
            Predicate specialPredicate = predicateManager.createPredicate(feature, specialCodes);
            predicates.add(specialPredicate);
            categories = OptimalBinningUtil.ensureCategory(categories, CATEGORY_SPECIAL);
        } else {
            predicates.add(null);
        }
        Predicate missingPredicate = predicateManager.createSimplePredicate(feature, SimplePredicate.Operator.IS_MISSING, null);
        predicates.add(missingPredicate);
        categories = OptimalBinningUtil.ensureCategory(categories, CATEGORY_MISSING);
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("optBinning", new Object[]{feature}), OpType.CATEGORICAL, DataType.DOUBLE, (Expression)expression);
        feature = new BinnedFeature((PMMLEncoder)encoder, derivedField, categories, predicates);
        return Collections.singletonList(feature);
    }

    private Discretize encodeNumericalBinning(Feature feature, List<Number> splits, List<Double> categoriesOut, PredicateManager predicateManager, List<Predicate> predicates) {
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        Discretize discretize = new Discretize(continuousFeature.getName()).setMapMissingTo((Object)CATEGORY_MISSING);
        for (int i = 0; i <= splits.size(); ++i) {
            Number leftMargin = null;
            Number rightMargin = null;
            if (i == 0) {
                rightMargin = splits.get(i);
            } else if (i == splits.size()) {
                leftMargin = splits.get(i - 1);
            } else {
                leftMargin = splits.get(i - 1);
                rightMargin = splits.get(i);
            }
            Interval interval = new Interval(Interval.Closure.CLOSED_OPEN).setLeftMargin(leftMargin).setRightMargin(rightMargin);
            DiscretizeBin discretizeBin = new DiscretizeBin((Object)categoriesOut.get(i), interval);
            discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
            Predicate leftPredicate = null;
            Predicate rightPredicate = null;
            if (leftMargin != null) {
                leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_OR_EQUAL, (Object)leftMargin);
            }
            if (rightMargin != null) {
                rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_THAN, (Object)rightMargin);
            }
            Predicate predicate = leftPredicate != null && rightPredicate != null ? predicateManager.createCompoundPredicate(CompoundPredicate.BooleanOperator.AND, new Predicate[]{leftPredicate, rightPredicate}) : (leftPredicate != null ? leftPredicate : rightPredicate);
            predicates.add(predicate);
        }
        return discretize;
    }

    private MapValues encodeCategoricalBinning(Feature feature, List<Number> splits, List<?> categoriesIn, List<Double> categoriesOut, PredicateManager predicateManager, List<Predicate> predicates) {
        ArrayList inputValues = new ArrayList();
        ArrayList<Double> outputValues = new ArrayList<Double>();
        int begin = 0;
        for (int i = 0; i <= splits.size(); ++i) {
            int end;
            Double splitCategoryOut = categoriesOut.get(i);
            if (i < splits.size()) {
                Number split = splits.get(i);
                end = (int)Math.ceil(split.doubleValue());
            } else {
                end = categoriesIn.size();
            }
            List<?> splitCategoriesIn = categoriesIn.subList(begin, end);
            for (Object splitCategoryIn : splitCategoriesIn) {
                inputValues.add(splitCategoryIn);
                outputValues.add(splitCategoryOut);
            }
            begin = end;
            Predicate predicate = predicateManager.createPredicate(feature, splitCategoriesIn);
            predicates.add(predicate);
        }
        MapValues mapValues = PMMLUtil.createMapValues((String)feature.getName(), inputValues, outputValues).setMapMissingTo((Object)CATEGORY_MISSING);
        return mapValues;
    }

    public List<?> getCategoriesIn() {
        return this.getArray("_categories");
    }

    public List<Double> getCategoriesOut() {
        String metric = this.getMetric();
        List<Integer> numberOfEvents = this.getNumberOfEvents();
        List<Integer> numberOfNonEvents = this.getNumberOfNonEvents();
        switch (metric) {
            case "event_rate": 
            case "woe": {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{numberOfEvents, numberOfNonEvents});
        double constant = Math.log((double)OptimalBinningUtil.sumExact(numberOfEvents) / (double)OptimalBinningUtil.sumExact(numberOfNonEvents));
        ArrayList<Double> result = new ArrayList<Double>();
        block15: for (int i = 0; i < numberOfEvents.size(); ++i) {
            double eventRate = (double)numberOfEvents.get(i).intValue() / (double)Math.addExact(numberOfEvents.get(i), numberOfNonEvents.get(i));
            switch (metric) {
                case "event_rate": {
                    result.add(eventRate);
                    continue block15;
                }
                case "woe": {
                    double woe = Math.log(1.0 / eventRate - 1.0) + constant;
                    result.add(woe);
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return result;
    }

    public String getDType() {
        return this.getString("dtype");
    }

    public String getDefaultMetric() {
        return "woe";
    }

    public String getMetric() {
        if (!this.containsKey("metric")) {
            return this.getDefaultMetric();
        }
        return this.getString("metric");
    }

    public OptimalBinning setMetric(String metric) {
        this.put("metric", metric);
        return this;
    }

    public List<Integer> getNumberOfEvents() {
        return this.getIntegerArray("_n_event");
    }

    public List<Integer> getNumberOfNonEvents() {
        return this.getIntegerArray("_n_nonevent");
    }

    public List<Number> getSpecialCodes() {
        Object specialCodes = this.get("special_codes");
        if (specialCodes == null) {
            return Collections.emptyList();
        }
        return this.getListLike("special_codes", Number.class);
    }

    public List<Number> getSplitsOptimal() {
        return this.getNumberArray("_splits_optimal");
    }
}

