/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.MultiTransformer;

public class RareCategoryGrouping
extends MultiTransformer {
    public RareCategoryGrouping(String module, String name) {
        super(module, name);
    }

    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Map<String, ?> toOther = this.getToOther();
        Object value = this.getValue();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            List categories = (List)toOther.get(feature.getName());
            if (categories == null) {
                throw new IllegalArgumentException();
            }
            if (!categories.isEmpty()) {
                DataType dataType = feature.getDataType();
                Apply valueApply = PMMLUtil.createApply((String)(categories.size() == 1 ? "equal" : "isIn"), (Expression[])new Expression[]{feature.ref()});
                for (Object category : categories) {
                    valueApply.addExpressions(new Expression[]{PMMLUtil.createConstant(category, (DataType)dataType)});
                }
                Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{valueApply, PMMLUtil.createConstant((Object)value, (DataType)dataType), feature.ref()});
                DerivedField derivedField = encoder.createDerivedField(this.createFieldName("rareCategoryGrouping", new Object[]{feature}), OpType.CATEGORICAL, dataType, (Expression)apply);
                feature = FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder);
            }
            result.add(feature);
        }
        return result;
    }

    public Map<String, ?> getToOther() {
        return this.getDict("_to_other");
    }

    public Object getValue() {
        return this.getScalar("value");
    }
}

