/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.Value;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import pycaret.preprocess.TransformerWrapper;
import sklearn.InitializerUtil;
import sklearn.ScalarLabelUtil;
import sklearn.preprocessing.LabelEncoder;
import sklearn2pmml.decoration.DomainUtil;

public class TransformerWrapperWithInverse
extends TransformerWrapper {
    public TransformerWrapperWithInverse(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<String> featureNamesIn = this.getFeatureNamesIn();
        LabelEncoder transformer = this.getTransformer();
        Label label = encoder.getLabel();
        if (label == null) {
            throw new IllegalArgumentException();
        }
        ScalarLabel scalarLabel = (ScalarLabel)label;
        ArrayList<Feature> result = features.isEmpty() ? InitializerUtil.selectFeatures(featureNamesIn, Collections.emptyList(), (SkLearnEncoder)encoder) : features;
        Feature labelFeature = ScalarLabelUtil.findLabelFeature((ScalarLabel)scalarLabel, (List)result);
        if (labelFeature == null) {
            List names = result.stream().map(feature -> feature.getName()).collect(Collectors.toList());
            throw new IllegalArgumentException("Column '" + scalarLabel.getName() + "' not found in " + names);
        }
        int labelFeatureIndex = result.indexOf(labelFeature);
        if (!(labelFeature instanceof WildcardFeature)) {
            throw new IllegalArgumentException();
        }
        WildcardFeature wildcardFeature = (WildcardFeature)labelFeature;
        DataField dataField = wildcardFeature.getField();
        DomainUtil.clearValues((Field)dataField, (Value.Property)Value.Property.VALID);
        Feature transformedLabelFeature = (Feature)Iterables.getOnlyElement((Iterable)transformer.encode(Collections.singletonList(labelFeature), encoder));
        result = new ArrayList<Feature>(result);
        result.set(labelFeatureIndex, transformedLabelFeature);
        return result;
    }

    public LabelEncoder getTransformer() {
        return (LabelEncoder)this.get("transformer", LabelEncoder.class);
    }
}

