/*
 * Decompiled with CFR 0.152.
 */
package optbinning.scorecard;

import java.util.List;
import java.util.stream.Collectors;
import numpy.DTypeUtil;
import optbinning.BinnedFeature;
import optbinning.BinningProcess;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.BlockManager;
import pandas.core.DataFrame;
import pandas.core.Index;
import sklearn.Estimator;
import sklearn.HasClasses;

public class Scorecard
extends Estimator
implements HasClasses {
    public Scorecard(String module, String name) {
        super(module, name);
    }

    public MiningFunction getMiningFunction() {
        Estimator estimator = this.getEstimator();
        String scalingMethod = this.getScalingMethod();
        if (scalingMethod != null) {
            return MiningFunction.REGRESSION;
        }
        return estimator.getMiningFunction();
    }

    public List<?> getClasses() {
        Estimator estimator = this.getEstimator();
        if (estimator instanceof HasClasses) {
            HasClasses hasClasses = (HasClasses)estimator;
            return hasClasses.getClasses();
        }
        throw new UnsupportedOperationException();
    }

    public Model encodeModel(Schema schema) {
        BinningProcess binningProcess = this.getBinningProcess();
        Estimator estimator = this.getEstimator();
        String scalingMethod = this.getScalingMethod();
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        features = binningProcess.encode(features, encoder);
        schema = new Schema((PMMLEncoder)encoder, label, features);
        if (scalingMethod != null) {
            return this.encodeScorecard(schema);
        }
        return estimator.encode(schema);
    }

    private org.dmg.pmml.scorecard.Scorecard encodeScorecard(Schema schema) {
        DataFrame dfScorecard = this.getDFScorecard();
        Number intercept = this.getIntercept();
        BlockManager data = dfScorecard.getData();
        Index rowAxis = data.getRowAxis();
        List rowValues = rowAxis.getArrayContent();
        List blockValues = data.getBlockValues();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        Characteristics characteristics = new Characteristics();
        HasArray pointBlockValues = Scorecard.getPoints(blockValues);
        List pointValues = pointBlockValues.getArrayContent();
        if (pointValues.size() > rowValues.size()) {
            pointValues = pointValues.subList(pointValues.size() - rowValues.size(), pointValues.size());
        }
        int index = 0;
        for (Feature feature : features) {
            BinnedFeature binnedFeature = (BinnedFeature)feature;
            Characteristic characteristic = new Characteristic().setName(binnedFeature.getName());
            List<Predicate> predicates = binnedFeature.getPredicates();
            for (Predicate predicate : predicates) {
                if (predicate != null) {
                    Attribute attribute = new Attribute(predicate).setPartialScore((Number)pointValues.get(index));
                    characteristic.addAttributes(new Attribute[]{attribute});
                }
                ++index;
            }
            characteristics.addCharacteristics(new Characteristic[]{characteristic});
        }
        if (index != pointValues.size()) {
            throw new IllegalArgumentException();
        }
        org.dmg.pmml.scorecard.Scorecard scorecard = new org.dmg.pmml.scorecard.Scorecard(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)label), characteristics).setInitialScore(intercept).setUseReasonCodes(Boolean.valueOf(false));
        return scorecard;
    }

    public BinningProcess getBinningProcess() {
        return (BinningProcess)((Object)this.get("binning_process_", BinningProcess.class));
    }

    public DataFrame getDFScorecard() {
        return (DataFrame)this.get("_df_scorecard", DataFrame.class);
    }

    public Estimator getEstimator() {
        return (Estimator)this.get("estimator_", Estimator.class);
    }

    public Number getIntercept() {
        return this.getNumber("intercept_");
    }

    public String getScalingMethod() {
        return this.getOptionalString("scaling_method");
    }

    private static HasArray getPoints(List<HasArray> blockValues) {
        blockValues = blockValues.stream().filter(blockValue -> {
            Object descr = blockValue.getArrayType();
            DataType dataType = DTypeUtil.getDataType((Object)descr);
            return dataType == DataType.DOUBLE;
        }).collect(Collectors.toList());
        return (HasArray)blockValues.get(blockValues.size() - 1);
    }
}

