/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.Value;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.ScalarLabelUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import pycaret.preprocess.TransformerWrapper;
import sklearn.InitializerUtil;
import sklearn.preprocessing.LabelEncoder;

public class TransformerWrapperWithInverse
extends TransformerWrapper {
    public TransformerWrapperWithInverse(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        ScalarLabel scalarLabel;
        List<String> featureNames = this.getFeatureNames();
        LabelEncoder transformer = this.getTransformer();
        Label label = encoder.getLabel();
        if (label == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = features.isEmpty() ? InitializerUtil.selectFeatures(featureNames, Collections.emptyList(), (SkLearnEncoder)encoder) : features;
        Feature labelFeature = FeatureUtil.findLabelFeature((List)result, (ScalarLabel)(scalarLabel = (ScalarLabel)label));
        if (labelFeature == null) {
            throw new IllegalArgumentException("Column '" + scalarLabel.getName() + "' not found in " + FeatureUtil.formatNames((List)result, (char)'\''));
        }
        int labelFeatureIndex = result.indexOf(labelFeature);
        if (!(labelFeature instanceof WildcardFeature)) {
            throw new IllegalArgumentException();
        }
        WildcardFeature wildcardFeature = (WildcardFeature)labelFeature;
        DataField dataField = wildcardFeature.getField();
        PMMLUtil.clearValues((Field)dataField, (Value.Property)Value.Property.VALID);
        Feature transformedLabelFeature = (Feature)Iterables.getOnlyElement((Iterable)transformer.encode(Collections.singletonList(labelFeature), encoder));
        result = new ArrayList<Feature>(result);
        result.set(labelFeatureIndex, transformedLabelFeature);
        scalarLabel = ScalarLabelUtil.createScalarLabel((DataField)dataField);
        encoder.setLabel((Label)scalarLabel);
        return result;
    }

    public LabelEncoder getTransformer() {
        return (LabelEncoder)this.get("transformer", LabelEncoder.class);
    }
}

