/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseNFeature;
import category_encoders.CategoryEncoder;
import category_encoders.OrdinalEncoder;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.EncoderUtil;

public class BaseNEncoder
extends CategoryEncoder {
    public BaseNEncoder(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Integer base = this.getBase();
        List<?> cols = this.getCols();
        List<String> invariantCols = null;
        Boolean dropInvariant = this.getDropInvariant();
        List<String> featureNamesOut = this.getFeatureNamesOut();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        OrdinalEncoder ordinalEncoder = this.getOrdinalEncoder();
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException(Integer.toString(base));
        }
        if (dropInvariant.booleanValue()) {
            invariantCols = this.getInvariantCols();
        }
        Object missingCategory = null;
        switch (handleMissing) {
            case "error": 
            case "return_nan": {
                break;
            }
            case "value": {
                missingCategory = CategoryEncoder.CATEGORY_NAN;
                break;
            }
            default: {
                throw new IllegalArgumentException(handleMissing);
            }
        }
        Integer defaultValue = null;
        switch (handleUnknown) {
            case "error": {
                break;
            }
            case "value": {
                defaultValue = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(handleUnknown);
            }
        }
        List<OrdinalEncoder.Mapping> ordinalMappings = ordinalEncoder.getMapping();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, cols, ordinalMappings});
        int numberOfBaseNFeatures = 0;
        for (int i = 0; i < features.size(); ++i) {
            Object col = cols.get(i);
            OrdinalEncoder.Mapping ordinalMapping = ordinalMappings.get(i);
            Map<?, Integer> ordinalCategoryMappings = ordinalMapping.getCategoryMapping();
            int requiredDigits = BaseNEncoder.calcRequiredDigits(ordinalCategoryMappings, base, true);
            for (int pos = 0; pos < requiredDigits; ++pos) {
                String featureCol = String.valueOf(col) + "_" + String.valueOf(pos);
                if (invariantCols != null && invariantCols.contains(featureCol)) continue;
                ++numberOfBaseNFeatures;
            }
        }
        boolean pre23Mode = numberOfBaseNFeatures == featureNamesOut.size();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Object col = cols.get(i);
            OrdinalEncoder.Mapping ordinalMapping = ordinalMappings.get(i);
            Map<?, Integer> ordinalCategoryMappings = ordinalMapping.getCategoryMapping();
            ArrayList categories = new ArrayList(ordinalCategoryMappings.keySet());
            Field field = encoder.toCategorical(feature.getName(), EncoderUtil.filterCategories(categories));
            switch (handleUnknown) {
                case "value": {
                    EncoderUtil.addDecorator((Field)field, (Decorator)new InvalidValueDecorator(InvalidValueTreatmentMethod.AS_IS, null), (ModelEncoder)encoder);
                    break;
                }
            }
            int requiredDigits = BaseNEncoder.calcRequiredDigits(ordinalCategoryMappings, base, pre23Mode);
            Map<Object, String> baseCategoryMappings = BaseNEncoder.baseEncodeValues(ordinalCategoryMappings, base, requiredDigits);
            ArrayList<BaseNFeature> baseFeatures = new ArrayList<BaseNFeature>();
            for (int pos = 0; pos < requiredDigits; ++pos) {
                String featureCol = String.valueOf(col) + "_" + String.valueOf(pos);
                if (invariantCols != null && invariantCols.contains(featureCol)) continue;
                LinkedHashMultimap values = LinkedHashMultimap.create();
                Set<Map.Entry<Object, String>> entries = baseCategoryMappings.entrySet();
                for (Map.Entry entry : entries) {
                    Object category = entry.getKey();
                    String baseValue = (String)entry.getValue();
                    char digit = baseValue.charAt(pos);
                    values.put((Object)Character.getNumericValue(digit), category);
                }
                BaseNFeature baseFeature = new BaseNFeature((PMMLEncoder)encoder, feature, (int)base, pos, (SetMultimap<Integer, ?>)values, missingCategory, defaultValue);
                baseFeatures.add(baseFeature);
            }
            result.addAll(baseFeatures);
        }
        return result;
    }

    public Integer getBase() {
        return this.getInteger("base");
    }

    public OrdinalEncoder getOrdinalEncoder() {
        return (OrdinalEncoder)((Object)this.get("ordinal_encoder", OrdinalEncoder.class));
    }

    private static int calcRequiredDigits(Map<?, Integer> ordinalCategoryMappings, int base, boolean pre23Mode) {
        if (base == 1) {
            return ordinalCategoryMappings.size() + 1;
        }
        if (pre23Mode) {
            return (int)Math.ceil(Math.log(ordinalCategoryMappings.size()) / Math.log(base)) + 1;
        }
        return BaseNEncoder.ceillogint(ordinalCategoryMappings.size() + 1, base);
    }

    private static int ceillogint(int n, int base) {
        int result = 0;
        --n;
        while (n > 0) {
            ++result;
            n = IntMath.divide((int)n, (int)base, (RoundingMode)RoundingMode.FLOOR);
        }
        return result;
    }

    public static Map<Object, String> baseEncodeValues(Map<?, Integer> categoryMappings, int base, int requiredDigits) {
        LinkedHashMap<Object, String> result = new LinkedHashMap<Object, String>();
        Set<Map.Entry<?, Integer>> entries = categoryMappings.entrySet();
        for (Map.Entry entry : entries) {
            String baseValue = Strings.padStart((String)Integer.toString((Integer)entry.getValue(), base), (int)requiredDigits, (char)'0');
            result.put(entry.getKey(), baseValue);
        }
        return result;
    }
}

