/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import optbinning.OptimalBinning;
import org.jpmml.converter.Feature;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;
import sklearn.InitializerUtil;

public class BinningProcess
extends Initializer {
    public BinningProcess(String module, String name) {
        super(module, name);
    }

    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        return this.encodeFeatures(Collections.emptyList(), encoder);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Boolean> support = this.getSupport();
        Map<String, OptimalBinning> binnedVariables = this.getBinnedVariables();
        Map<String, Map<String, ?>> binningFitParams = this.getBinningFitParams();
        Map<String, Map<String, ?>> binningTransformParams = this.getBinningTransformParams();
        List<String> variableNames = this.getVariableNames();
        Map<String, String> variableDTypes = this.getVariableDTypes();
        Map<String, Map<String, ?>> variableStats = this.getVariableStats();
        ClassDictUtil.checkSize((Collection[])new Collection[]{support, variableNames, variableDTypes.values(), variableStats.values()});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < support.size(); ++i) {
            boolean flag = support.get(i);
            if (!flag) continue;
            String variableName = variableNames.get(i);
            Feature feature = InitializerUtil.selectFeature((String)variableName, features, (SkLearnEncoder)encoder);
            OptimalBinning optimalBinning = binnedVariables.get(variableName);
            Map<String, ?> fitParams = binningFitParams.get(variableName);
            Map<String, ?> transformParams = binningTransformParams.get(variableName);
            if (transformParams != null && !transformParams.isEmpty()) {
                Set<Map.Entry<String, ?>> entries = transformParams.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (optimalBinning.containsKey(key)) continue;
                    optimalBinning.put(key, value);
                }
            }
            feature = (Feature)Iterables.getOnlyElement((Iterable)optimalBinning.encode(Collections.singletonList(feature), encoder));
            result.add(feature);
        }
        return result;
    }

    public Map<String, OptimalBinning> getBinnedVariables() {
        Map binnedVariables = this.getDict("_binned_variables");
        CastFunction<OptimalBinning> castFunction = new CastFunction<OptimalBinning>(OptimalBinning.class){

            protected String formatMessage(Object object) {
                return "The binning object (" + ClassDictUtil.formatClass((Object)object) + ") is not supported";
            }
        };
        return Maps.transformValues((Map)binnedVariables, (Function)castFunction);
    }

    public Map<String, Map<String, ?>> getBinningFitParams() {
        return this.getBinningParams("binning_fit_params");
    }

    public Map<String, Map<String, ?>> getBinningTransformParams() {
        return this.getBinningParams("binning_transform_params");
    }

    private Map<String, Map<String, ?>> getBinningParams(String name) {
        Object binningParams = this.get(name);
        if (binningParams == null) {
            return Collections.emptyMap();
        }
        return this.getDict(name);
    }

    public List<Boolean> getSupport() {
        return this.getArray("_support", Boolean.class);
    }

    public List<String> getVariableNames() {
        return this.getListLike("variable_names", String.class);
    }

    public Map<String, String> getVariableDTypes() {
        return this.getDict("_variable_dtypes");
    }

    public Map<String, Map<String, ?>> getVariableStats() {
        return this.getDict("_variable_stats");
    }
}

