/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.CategoryEncoder;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.BinaryThresholdFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.IfElseBuilder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.ToStringHelper;

public class BaseNFeature
extends BinaryThresholdFeature {
    private int base = -1;
    private int index = -1;
    private SetMultimap<Integer, ?> values = null;
    private Object missingCategory = null;
    private Integer defaultValue = null;

    public BaseNFeature(PMMLEncoder encoder, Field<?> field, int base, int index, SetMultimap<Integer, ?> values, Object missingCategory, Integer defaultValue) {
        this(encoder, field.requireName(), field.requireDataType(), base, index, values, missingCategory, defaultValue);
    }

    public BaseNFeature(PMMLEncoder encoder, Feature feature, int base, int index, SetMultimap<Integer, ?> values, Object missingCategory, Integer defaultValue) {
        this(encoder, feature.getName(), feature.getDataType(), base, index, values, missingCategory, defaultValue);
    }

    public BaseNFeature(PMMLEncoder encoder, String name, DataType dataType, int base, int index, SetMultimap<Integer, ?> values, Object missingCategory, Integer defaultValue) {
        super(encoder, name, dataType);
        this.setBase(base);
        this.setIndex(index);
        this.setValues(values);
        this.setMissingCategory(missingCategory);
        this.setDefaultValue(defaultValue);
    }

    public String getDerivedName() {
        return FieldNameUtil.create((String)("base" + this.getBase()), (Object[])new Object[]{this.getName(), this.getIndex()});
    }

    public ContinuousFeature toContinuousFeature() {
        boolean missingValueAware;
        String name = this.getName();
        DataType dataType = this.getDataType();
        int base = this.getBase();
        SetMultimap<Integer, ?> values = this.getValues();
        Object missingCategory = this.getMissingCategory();
        Integer defaultValue = this.getDefaultValue();
        boolean bl = missingValueAware = missingCategory != null && values.containsValue(missingCategory);
        if (defaultValue != null && defaultValue != 0) {
            throw new IllegalArgumentException();
        }
        Supplier<Expression> expressionSupplier = () -> {
            Collection categories;
            Map valueMap = values.asMap();
            if (base == 2 && (categories = (Collection)valueMap.get(1)) != null && categories.size() == 1) {
                Object category = Iterables.getOnlyElement((Iterable)categories);
                if (!missingValueAware) {
                    return new NormDiscrete(name, category);
                }
            }
            Integer missingBaseValue = 0;
            IfElseBuilder applyBuilder = new IfElseBuilder();
            Collection entries = valueMap.entrySet();
            entries = entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            for (Map.Entry entry2 : entries) {
                Integer baseValue = (Integer)entry2.getKey();
                Collection categories2 = (Collection)entry2.getValue();
                if (missingValueAware) {
                    if (categories2.contains(missingCategory)) {
                        categories2.remove(missingCategory);
                        missingBaseValue = baseValue;
                    }
                } else if (categories2.contains(CategoryEncoder.CATEGORY_NAN)) {
                    categories2.remove(CategoryEncoder.CATEGORY_NAN);
                }
                if (categories2.isEmpty()) continue;
                Apply valueApply = ExpressionUtil.createValueApply((Expression)new FieldRef(name), (DataType)dataType, (Collection)categories2);
                applyBuilder.add((Expression)valueApply, (Expression)ExpressionUtil.createConstant((Number)baseValue));
            }
            if (applyBuilder.isEmpty()) {
                return ExpressionUtil.createConstant((Number)0);
            }
            applyBuilder.terminate((Expression)ExpressionUtil.createConstant((Number)0));
            Apply apply = applyBuilder.build();
            if (missingValueAware) {
                apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{new FieldRef(name)}), apply, ExpressionUtil.createConstant((Number)missingBaseValue)});
            }
            return apply;
        };
        return this.toContinuousFeature(this.getDerivedName(), DataType.INTEGER, expressionSupplier);
    }

    public Set<?> getValues(Predicate<Number> predicate) {
        SetMultimap<Integer, ?> values = this.getValues();
        Integer defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            throw new IllegalArgumentException();
        }
        Map valueMap = values.asMap();
        LinkedHashSet result = new LinkedHashSet();
        Set entries = valueMap.entrySet();
        entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> predicate.test((Number)entry.getKey())).map(entry -> (Collection)entry.getValue()).forEach(result::addAll);
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getBase());
        result = 31 * result + Objects.hash(this.getIndex());
        result = 31 * result + Objects.hash(this.getValues());
        result = 31 * result + Objects.hash(this.getMissingCategory());
        result = 31 * result + Objects.hash(this.getDefaultValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof BaseNFeature) {
            BaseNFeature that = (BaseNFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getBase(), that.getBase()) && Objects.equals(this.getIndex(), that.getIndex()) && Objects.equals(this.getValues(), that.getValues()) && Objects.equals(this.getMissingCategory(), that.getMissingCategory()) && Objects.equals(this.getDefaultValue(), that.getDefaultValue());
        }
        return false;
    }

    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("base", (Object)this.getBase()).add("index", (Object)this.getIndex()).add("values", this.getValues()).add("missingCategory", this.getMissingCategory()).add("defaultValue", (Object)this.getDefaultValue());
    }

    public int getBase() {
        return this.base;
    }

    private void setBase(int base) {
        this.base = base;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public SetMultimap<Integer, ?> getValues() {
        return this.values;
    }

    private void setValues(SetMultimap<Integer, ?> values) {
        this.values = Objects.requireNonNull(values);
    }

    public Object getMissingValue() {
        return this.getMissingCategory();
    }

    public Object getMissingCategory() {
        return this.missingCategory;
    }

    private void setMissingCategory(Object missingCategory) {
        this.missingCategory = missingCategory;
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    private void setDefaultValue(Integer defaultValue) {
        this.defaultValue = defaultValue;
    }
}

