/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseEncoderConstants;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.jpmml.sklearn.Encodable;
import sklearn.HasFeatureNamesIn;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public abstract class BaseEncoder
extends Transformer
implements HasFeatureNamesIn,
Encodable,
BaseEncoderConstants {
    public static final Object CATEGORY_NAN = Double.NaN;

    public BaseEncoder(String module, String name) {
        super(module, name);
    }

    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    public DataType getDataType() {
        return DataType.STRING;
    }

    public List<String> getFeatureNamesIn() {
        if (this.hasattr("feature_names_in_")) {
            return this.getListLike("feature_names_in_", String.class);
        }
        return null;
    }

    public PMML encodePMML() {
        return TransformerUtil.encodePMML((Transformer)this);
    }

    public List<Object> getCols() {
        return this.getObjectList("cols");
    }

    public List<String> getInvariantCols() {
        if (this.hasattr("drop_cols")) {
            return this.getStringList("drop_cols");
        }
        return this.getStringList("invariant_cols");
    }

    public Boolean getDropInvariant() {
        return (Boolean)this.getEnum("drop_invariant", arg_0 -> ((BaseEncoder)this).getBoolean(arg_0), Arrays.asList(Boolean.FALSE));
    }

    public List<String> getFeatureNamesOut() {
        if (this.hasattr("feature_names")) {
            return this.getStringList("feature_names");
        }
        return this.getStringList("feature_names_out_");
    }

    public String getHandleMissing() {
        return (String)this.getEnum("handle_missing", arg_0 -> ((BaseEncoder)this).getString(arg_0), ENUM_HANDLEMISSING);
    }

    public String getHandleUnknown() {
        return (String)this.getEnum("handle_unknown", arg_0 -> ((BaseEncoder)this).getString(arg_0), ENUM_HANDLEUNKNOWN);
    }
}

