/*
 * Decompiled with CFR 0.152.
 */
package sktree.ensemble.eiforest;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.OutlierDetector;
import sklearn.Regressor;
import sklearn.ensemble.iforest.HasIsolationForest;
import sklearn.ensemble.iforest.IsolationForestUtil;
import sklearn.tree.Tree;
import sktree.tree.ObliqueDecisionTreeRegressor;
import sktree.tree.ObliqueTree;
import sktree.tree.ProjectionManager;

public class ExtendedIsolationForest
extends Regressor
implements HasIsolationForest,
OutlierDetector {
    public ExtendedIsolationForest(String module, String name) {
        super(module, name);
    }

    public int getNumberOfOutputs() {
        return 0;
    }

    public boolean isSupervised() {
        return false;
    }

    public Label encodeLabel(List<String> names, SkLearnEncoder encoder) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiningModel encodeModel(Schema schema) {
        List<Regressor> estimators = this.getEstimators();
        List<List<Number>> estimatorsFeatures = this.getEstimatorsFeatures();
        boolean corrected = true;
        boolean nodeSampleCorrected = true;
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ProjectionManager projectionManager = new ProjectionManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (int i = 0; i < estimators.size(); ++i) {
            TreeModel treeModel;
            ObliqueDecisionTreeRegressor estimator = (ObliqueDecisionTreeRegressor)estimators.get(i);
            List<Number> estimatorFeatures = estimatorsFeatures.get(i);
            Schema estimatorSchema = segmentSchema.toSubSchema(Ints.toArray(estimatorFeatures));
            ObliqueTree tree = estimator.getTree();
            try {
                estimator.setPMMLSegmentId(i + 1);
                treeModel = estimator.encodeModel(predicateManager, projectionManager, estimatorSchema);
            }
            finally {
                estimator.setPMMLSegmentId(null);
            }
            IsolationForestUtil.transformTreeModel((TreeModel)treeModel, (Tree)tree, (boolean)corrected, (boolean)nodeSampleCorrected);
            treeModels.add(treeModel);
        }
        return IsolationForestUtil.encodeMiningModel((Estimator)this, treeModels, (boolean)corrected, (boolean)nodeSampleCorrected, (Schema)schema);
    }

    public List<Regressor> getEstimators() {
        return this.getList("estimators_", ObliqueDecisionTreeRegressor.class);
    }

    public List<List<Number>> getEstimatorsFeatures() {
        return this.getArrayList("estimators_features_", Number.class);
    }

    public Integer getMaxSamples() {
        return this.getInteger("_max_samples");
    }

    public Number getOffset() {
        return this.getNumber("offset_");
    }
}

