/*
 * Decompiled with CFR 0.152.
 */
package tpot.builtins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.HasClasses;
import sklearn.HasEstimator;
import sklearn.Transformer;

public class StackingEstimator
extends Transformer
implements HasEstimator<Estimator> {
    public StackingEstimator(String module, String name) {
        super(module, name);
    }

    public int getNumberOfFeatures() {
        Estimator estimator = this.getEstimator();
        return estimator.getNumberOfFeatures();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Estimator estimator = this.getEstimator();
        ScalarLabel scalarLabel = (ScalarLabel)estimator.encodeLabel(Collections.singletonList(null), encoder);
        Schema schema = new Schema((ModelEncoder)encoder, (Label)scalarLabel, features);
        Model model = estimator.encode(schema);
        encoder.addTransformer(model);
        String name = this.createFieldName("stack", features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        Feature feature = encoder.exportPrediction(model, name, scalarLabel);
        result.add(feature);
        MiningFunction miningFunction = estimator.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                HasClasses hasClasses = (HasClasses)estimator;
                if (!hasClasses.hasProbabilityDistribution()) break;
                List categories = hasClasses.getClasses();
                for (Object category : categories) {
                    Feature feature2 = encoder.exportProbability(model, FieldNameUtil.create((String)"probability", (Object[])new Object[]{name, category}), category);
                    result.add(feature2);
                }
                break;
            }
            case REGRESSION: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        result.addAll(features);
        return result;
    }

    public Estimator getEstimator() {
        return (Estimator)this.get("estimator", Estimator.class);
    }
}

