/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import optbinning.OptimalBinning;
import org.jpmml.python.ClassDictUtil;

public class ContinuousOptimalBinning
extends OptimalBinning {
    private static final String METRIC_MEAN = "mean";

    public ContinuousOptimalBinning(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Double> getCategoriesOut() {
        String metric = this.getMetric();
        List<Integer> numberOfRecords = this.getNumberOfRecords();
        List<Number> sums = this.getSums();
        switch (metric) {
            case "mean": {
                break;
            }
            default: {
                throw new IllegalArgumentException(metric);
            }
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{numberOfRecords, sums});
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < numberOfRecords.size(); ++i) {
            double mean = sums.get(i).doubleValue() / (double)numberOfRecords.get(i).intValue();
            result.add(mean);
        }
        return result;
    }

    @Override
    public String getDefaultMetric() {
        return METRIC_MEAN;
    }

    @Override
    public Collection<String> getSupportedMetrics() {
        return Arrays.asList(METRIC_MEAN);
    }

    public List<Integer> getNumberOfRecords() {
        return this.getIntegerArray("_n_records");
    }

    public List<Number> getSums() {
        return this.getNumberArray("_sums");
    }
}

