/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseEncoder;
import category_encoders.OrdinalEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.MissingValueFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.SkLearnEncoder;

public class OneHotEncoder
extends BaseEncoder {
    private static final String HANDLEMISSING_INDICATOR = "indicator";

    public OneHotEncoder(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        OrdinalEncoder ordinalEncoder = this.getOrdinalEncoder();
        features = ordinalEncoder.encode(features, encoder);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = (Feature)features.get(i);
            if (feature instanceof CategoricalFeature) {
                CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
                List categories = categoricalFeature.getValues();
                for (int j = 0; j < categories.size(); ++j) {
                    Object category = categories.get(j);
                    if (ValueUtil.isNaN(category)) {
                        switch (handleMissing) {
                            case "indicator": 
                            case "value": {
                                result.add((Feature)new MissingValueFeature((PMMLEncoder)encoder, (Feature)categoricalFeature));
                                break;
                            }
                        }
                        continue;
                    }
                    result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, category));
                }
                continue;
            }
            throw new IllegalArgumentException("Expected a categorical feature, got " + feature);
        }
        return result;
    }

    @Override
    public String getHandleMissing() {
        return (String)this.getEnum("handle_missing", arg_0 -> ((OneHotEncoder)this).getString(arg_0), Arrays.asList("error", "return_nan", HANDLEMISSING_INDICATOR, "value"));
    }

    public OrdinalEncoder getOrdinalEncoder() {
        return (OrdinalEncoder)this.get("ordinal_encoder", OrdinalEncoder.class);
    }
}

