/*
 * Decompiled with CFR 0.152.
 */
package sktree.ensemble.supervised_forest;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ScoreDistributionManager;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sklearn.SkLearnTypeException;
import sklearn.Estimator;
import sklearn.HasEstimatorEnsemble;
import sktree.tree.ObliqueDecisionTreeClassifier;
import sktree.tree.ObliqueDecisionTreeRegressor;
import sktree.tree.ProjectionManager;

public class ObliqueForestUtil {
    private ObliqueForestUtil() {
    }

    public static <E extends Estimator, T extends Estimator> MiningModel encodeObliqueForest(E estimator, MiningFunction miningFunction, Segmentation.MultipleModelMethod multipleModelMethod, Schema schema) {
        final List estimators = ((HasEstimatorEnsemble)estimator).getEstimators();
        final Schema segmentSchema = schema.toAnonymousSchema();
        final PredicateManager predicateManager = new PredicateManager();
        final ScoreDistributionManager scoreDistributionManager = miningFunction == MiningFunction.CLASSIFICATION ? new ScoreDistributionManager() : null;
        final ProjectionManager projectionManager = new ProjectionManager();
        Function function = new Function<T, TreeModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TreeModel apply(T estimator) {
                TreeModel treeModel;
                block6: {
                    int i = estimators.indexOf(estimator);
                    if (i < 0) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        estimator.setPMMLSegmentId((Object)(i + 1));
                        if (estimator instanceof ObliqueDecisionTreeClassifier) {
                            ObliqueDecisionTreeClassifier classifier = (ObliqueDecisionTreeClassifier)((Object)estimator);
                            treeModel = classifier.encodeModel(predicateManager, scoreDistributionManager, projectionManager, segmentSchema);
                            break block6;
                        }
                        if (estimator instanceof ObliqueDecisionTreeRegressor) {
                            ObliqueDecisionTreeRegressor regressor = (ObliqueDecisionTreeRegressor)((Object)estimator);
                            treeModel = regressor.encodeModel(predicateManager, projectionManager, segmentSchema);
                            break block6;
                        }
                        throw new SkLearnTypeException(estimator, new Class[]{ObliqueDecisionTreeClassifier.class, ObliqueDecisionTreeRegressor.class});
                    }
                    finally {
                        estimator.setPMMLSegmentId(null);
                    }
                }
                return treeModel;
            }
        };
        List treeModels = estimators.stream().map(function).collect(Collectors.toList());
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels));
        return miningModel;
    }
}

