/*
 * Decompiled with CFR 0.152.
 */
package sktree.tree;

import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import sklearn.Estimator;
import sklearn.Regressor;
import sklearn.tree.HasTree;
import sklearn.tree.TreeUtil;
import sktree.tree.ObliqueTree;
import sktree.tree.ProjectionManager;

public class ObliqueDecisionTreeRegressor
extends Regressor
implements HasTree {
    public ObliqueDecisionTreeRegressor(String module, String name) {
        super(module, name);
    }

    public ObliqueDecisionTreeRegressor(ObliqueDecisionTreeRegressor that) {
        this(that.getPythonModule(), that.getPythonName());
        this.update((Map)((Object)that));
    }

    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public TreeModel encodeModel(Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        ProjectionManager projectionManager = new ProjectionManager();
        return this.encodeModel(predicateManager, projectionManager, schema);
    }

    public TreeModel encodeModel(PredicateManager predicateManager, ProjectionManager projectionManager, Schema schema) {
        final ObliqueTree tree = this.getTree();
        if (tree.hasProjVecs()) {
            Object segmentId = this.getPMMLSegmentId();
            final Schema sklearnSchema = tree.transformSchema(segmentId, projectionManager, schema);
            ObliqueDecisionTreeRegressor sklearnRegressor = new ObliqueDecisionTreeRegressor(this){
                private ObliqueTree sklearnTree;
                {
                    super(that);
                    this.sklearnTree = tree.transform(sklearnSchema);
                }

                @Override
                public ObliqueTree getTree() {
                    return this.sklearnTree;
                }
            };
            return sklearnRegressor.encodeModel(predicateManager, projectionManager, sklearnSchema);
        }
        return TreeUtil.encodeTreeModel((Estimator)this, (MiningFunction)MiningFunction.REGRESSION, (PredicateManager)predicateManager, null, (Schema)schema);
    }

    public ObliqueTree getTree() {
        return (ObliqueTree)((Object)this.get("tree_", ObliqueTree.class));
    }

    public boolean hasMissingValueSupport() {
        return false;
    }
}

