/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import java.util.LinkedHashMap;
import java.util.Map;
import lightgbm.sklearn.Booster;
import lightgbm.sklearn.HasBooster;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.HasLightGBMOptions;
import org.jpmml.lightgbm.ObjectiveFunction;
import sklearn.Estimator;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator> int getNumberOfFeatures(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        String[] featureNames = gbdt.getFeatureNames();
        return featureNames.length;
    }

    public static <E extends Estimator> ObjectiveFunction getObjectiveFunction(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        return gbdt.getObjectiveFunction();
    }

    public static <E extends Estimator & HasLightGBMOptions> MiningModel encodeModel(E estimator, Schema schema) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Integer bestIteration = (Integer)estimator.getOptionalScalar("best_iteration_");
        Boolean compact = (Boolean)estimator.getOption("compact", (Object)Boolean.TRUE);
        Integer numIteration = (Integer)estimator.getOption("num_iteration", (Object)bestIteration);
        LinkedHashMap<String, Comparable<Boolean>> options = new LinkedHashMap<String, Comparable<Boolean>>();
        options.put("compact", compact);
        options.put("num_iteration", numIteration);
        ModelEncoder encoder = (ModelEncoder)schema.getEncoder();
        Schema lgbmSchema = gbdt.toLightGBMSchema(schema);
        MiningModel miningModel = gbdt.encodeMiningModel(options, lgbmSchema);
        encoder.transferFeatureImportances(null, (Model)miningModel);
        return miningModel;
    }

    public static <E extends Estimator & HasLightGBMOptions> PMML encodePMML(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Map options = ((HasLightGBMOptions)estimator).getNativeConfiguration();
        return gbdt.encodePMML(options, null, null);
    }

    private static GBDT getGBDT(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getGBDT();
    }
}

