/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import com.google.common.io.CharStreams;
import java.io.StringReader;
import java.util.List;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.python.PythonObject;
import org.jpmml.sklearn.SkLearnException;

public class Booster
extends PythonObject {
    private GBDT gbdt = null;

    public Booster(String module, String name) {
        super(module, name);
    }

    public GBDT getGBDT() {
        if (this.gbdt == null) {
            this.gbdt = this.loadGBDT();
        }
        return this.gbdt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GBDT loadGBDT() {
        String handle = this.getHandle();
        try (StringReader reader = new StringReader(handle);){
            List lines = CharStreams.readLines((Readable)reader);
            GBDT gBDT = LightGBMUtil.loadGBDT(lines.iterator());
            return gBDT;
        }
        catch (Exception e) {
            throw new SkLearnException("Failed to load LightGBM booster object", (Throwable)e);
        }
    }

    public String getHandle() {
        if (this.hasattr("handle")) {
            return this.getString("handle");
        }
        return this.getString("_handle");
    }
}

