/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.ByteOrderUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.GBTree;
import org.jpmml.xgboost.HasXGBoostOptions;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.ObjFunction;
import sklearn.Estimator;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator & HasXGBoostOptions> int getNumberOfFeatures(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.num_feature();
    }

    public static <E extends Estimator & HasXGBoostOptions> ObjFunction getObjFunction(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.obj();
    }

    public static <E extends Estimator & HasXGBoostOptions> MiningModel encodeModel(E estimator, Schema schema) {
        Booster booster = ((HasBooster)estimator).getBooster();
        Integer bestNTreeLimit = booster.getBestNTreeLimit();
        Learner learner = BoosterUtil.getLearner(estimator);
        GBTree gbtree = learner.gbtree();
        if (bestNTreeLimit == null) {
            bestNTreeLimit = (Integer)estimator.getOptionalScalar("best_ntree_limit");
        }
        Number missing = (Number)estimator.getOptionalScalar("missing");
        Boolean compact = (Boolean)estimator.getOption("compact", (Object)(!gbtree.hasCategoricalSplits() ? 1 : 0));
        Boolean numeric = (Boolean)estimator.getOption("numeric", (Object)Boolean.TRUE);
        Boolean prune = (Boolean)estimator.getOption("prune", (Object)Boolean.TRUE);
        Integer ntreeLimit = (Integer)estimator.getOption("ntree_limit", (Object)bestNTreeLimit);
        LinkedHashMap<String, Serializable> options = new LinkedHashMap<String, Serializable>();
        options.put("missing", missing);
        options.put("compact", compact);
        options.put("numeric", numeric);
        options.put("prune", prune);
        options.put("ntree_limit", ntreeLimit);
        Schema xgbSchema = learner.toXGBoostSchema(numeric.booleanValue(), schema);
        MiningModel miningModel = learner.encodeMiningModel(options, xgbSchema);
        return miningModel;
    }

    public static <E extends Estimator & HasXGBoostOptions> PMML encodePMML(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        FeatureMap featureMap = learner.encodeFeatureMap();
        if (featureMap == null) {
            throw new IllegalArgumentException();
        }
        Map options = ((HasXGBoostOptions)estimator).getNativeConfiguration();
        return learner.encodePMML(options, null, null, featureMap);
    }

    private static <E extends Estimator & HasXGBoostOptions> Learner getLearner(E estimator) {
        Booster booster = ((HasBooster)estimator).getBooster();
        String byteOrder = (String)estimator.getOption("byte_order", (Object)ByteOrder.nativeOrder().toString());
        String charset = (String)estimator.getOption("charset", null);
        return booster.getLearner(ByteOrderUtil.forValue((String)byteOrder), charset);
    }
}

