/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.jpmml.python.PythonObject;
import org.jpmml.sklearn.SkLearnException;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;

public class Booster
extends PythonObject {
    private Learner learner = null;

    public Booster(String module, String name) {
        super(module, name);
    }

    public Learner getLearner(ByteOrder byteOrder, String charset) {
        if (this.learner == null) {
            this.learner = this.loadLearner(byteOrder, charset);
        }
        return this.learner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Learner loadLearner(ByteOrder byteOrder, String charset) {
        byte[] handle = this.getHandle();
        try (ByteArrayInputStream is = new ByteArrayInputStream(handle);){
            Learner learner = XGBoostUtil.loadLearner((InputStream)is, (ByteOrder)byteOrder, (String)charset, (String)"$.Model");
            return learner;
        }
        catch (Exception e) {
            throw new SkLearnException("Failed to load XGBoost booster object", (Throwable)e);
        }
    }

    public Integer getBestNTreeLimit() {
        if (!this.hasattr("best_ntree_limit")) {
            return null;
        }
        return this.getInteger("best_ntree_limit");
    }

    public byte[] getHandle() {
        return (byte[])this.get("handle", byte[].class);
    }
}

