/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.SkLearnException;
import org.jpmml.xgboost.Classification;
import org.jpmml.xgboost.HasXGBoostOptions;
import org.jpmml.xgboost.ObjFunction;
import sklearn.LabelEncoderClassifier;
import xgboost.sklearn.Booster;
import xgboost.sklearn.BoosterUtil;
import xgboost.sklearn.HasBooster;

public class XGBClassifier
extends LabelEncoderClassifier
implements HasBooster,
HasXGBoostOptions,
Encodable {
    public XGBClassifier(String module, String name) {
        super(module, name);
    }

    public int getNumberOfFeatures() {
        return BoosterUtil.getNumberOfFeatures(this);
    }

    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public List<?> getClasses() {
        if (this.hasattr("_le") || this.hasattr("classes_") || this.hasattr("pmml_classes_")) {
            return super.getClasses();
        }
        int numClasses = this.getNumberOfClasses();
        return LabelUtil.createTargetCategories((int)numClasses);
    }

    public void checkLabel(Label label) {
        ObjFunction objFunction = BoosterUtil.getObjFunction(this);
        super.checkLabel(label);
        if (objFunction != null && !(objFunction instanceof Classification)) {
            throw new SkLearnException("Expected a classification-type objective function, got '" + objFunction.getName() + "'");
        }
    }

    public MiningModel encodeModel(Schema schema) {
        return BoosterUtil.encodeModel(this, schema);
    }

    public PMML encodePMML() {
        return BoosterUtil.encodePMML(this);
    }

    @Override
    public Booster getBooster() {
        return (Booster)((Object)this.get("_Booster", Booster.class));
    }

    public int getNumberOfClasses() {
        return this.getInteger("n_classes_");
    }
}

