/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.SkLearnException;
import org.jpmml.xgboost.HasXGBoostOptions;
import org.jpmml.xgboost.ObjFunction;
import org.jpmml.xgboost.Regression;
import sklearn.Regressor;
import xgboost.sklearn.Booster;
import xgboost.sklearn.BoosterUtil;
import xgboost.sklearn.HasBooster;

public class XGBRegressor
extends Regressor
implements HasBooster,
HasXGBoostOptions,
Encodable {
    public XGBRegressor(String module, String name) {
        super(module, name);
    }

    public int getNumberOfFeatures() {
        return BoosterUtil.getNumberOfFeatures(this);
    }

    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public void checkLabel(Label label) {
        ObjFunction objFunction = BoosterUtil.getObjFunction(this);
        super.checkLabel(label);
        if (objFunction != null && !(objFunction instanceof Regression)) {
            throw new SkLearnException("Expected a regression-type objective function, got '" + objFunction.getName() + "'");
        }
    }

    protected ScalarLabel encodeLabel(String name, SkLearnEncoder encoder) {
        DataField dataField = encoder.createDataField(name, OpType.CONTINUOUS, DataType.FLOAT);
        return new ContinuousLabel((Field)dataField);
    }

    public MiningModel encodeModel(Schema schema) {
        return BoosterUtil.encodeModel(this, schema);
    }

    public Schema configureSchema(Schema schema) {
        return BoosterUtil.configureSchema(this, schema);
    }

    public MiningModel configureModel(Model model) {
        return BoosterUtil.configureModel(this, (MiningModel)model);
    }

    public PMML encodePMML() {
        return BoosterUtil.encodePMML(this);
    }

    @Override
    public Booster getBooster() {
        return (Booster)((Object)this.get("_Booster", Booster.class));
    }
}

