/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import numpy.core.NDArray;
import org.jpmml.converter.Feature;
import org.jpmml.python.ClassDictUtil;
import sklearn.Step;

public class StepUtil {
    private StepUtil() {
    }

    public static void checkNumberOfFeatures(Step step, List<? extends Feature> features) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures != -1 && numberOfFeatures != features.size()) {
            throw new IllegalArgumentException("Expected " + numberOfFeatures + " feature(s) (" + ClassDictUtil.formatClass((Object)step) + "), got " + features.size() + " feature(s)");
        }
    }

    public static int getNumberOfFeatures(List<? extends Step> steps) {
        Iterator<? extends Step> iterator = steps.iterator();
        if (iterator.hasNext()) {
            Step step = iterator.next();
            return step.getNumberOfFeatures();
        }
        return -1;
    }

    public static NDArray toArray(List<?> data) {
        NDArray result = new NDArray();
        result.put((Object)"data", data);
        result.put((Object)"fortran_order", (Object)Boolean.FALSE);
        result.put((Object)"shape", (Object)new Object[]{data.size()});
        return result;
    }
}

