/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.iforest;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ScoreDistributionManager;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.transformations.AbstractTransformation;
import org.jpmml.converter.transformations.OutlierTransformation;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import sklearn.HasDecisionFunctionField;
import sklearn.Regressor;
import sklearn.SkLearnOutlierTransformation;
import sklearn.SkLearnUtil;
import sklearn.ensemble.EnsembleRegressor;
import sklearn.ensemble.EnsembleUtil;
import sklearn.tree.HasTreeOptions;
import sklearn.tree.Tree;
import sklearn.tree.TreeRegressor;
import sklearn.tree.TreeUtil;

public class IsolationForest
extends EnsembleRegressor
implements HasDecisionFunctionField,
HasTreeOptions {
    public IsolationForest(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    public MiningModel encodeModel(Schema schema) {
        String sklearnVersion = this.getSkLearnVersion();
        List<? extends Regressor> estimators = this.getEstimators();
        List<List<Integer>> estimatorsFeatures = this.getEstimatorsFeatures();
        final boolean corrected = sklearnVersion != null && SkLearnUtil.compareVersion(sklearnVersion, "0.19") >= 0;
        final boolean nodeSampleCorrected = sklearnVersion != null && SkLearnUtil.compareVersion(sklearnVersion, "0.21") >= 0;
        Boolean numeric = (Boolean)this.getOption("numeric", Boolean.TRUE);
        PredicateManager predicateManager = new PredicateManager();
        ScoreDistributionManager scoreDistributionManager = new ScoreDistributionManager();
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (int i = 0; i < estimators.size(); ++i) {
            Regressor estimator = estimators.get(i);
            List<Integer> estimatorFeatures = estimatorsFeatures.get(i);
            Schema estimatorSchema = segmentSchema.toSubSchema(Ints.toArray(estimatorFeatures));
            TreeRegressor treeRegressor = (TreeRegressor)estimator;
            final Tree tree = treeRegressor.getTree();
            TreeModel treeModel = TreeUtil.encodeTreeModel(treeRegressor, MiningFunction.REGRESSION, numeric, predicateManager, scoreDistributionManager, estimatorSchema);
            AbstractVisitor visitor = new AbstractVisitor(){
                private int[] nodeSamples;
                {
                    this.nodeSamples = tree.getNodeSamples();
                }

                public VisitorAction visit(Node node) {
                    if (node.hasScore()) {
                        PMMLObject parent;
                        double nodeDepth = 0.0;
                        Deque parents = this.getParents();
                        Iterator iterator = parents.iterator();
                        while (iterator.hasNext() && (parent = (PMMLObject)iterator.next()) instanceof Node) {
                            nodeDepth += 1.0;
                        }
                        double nodeSample = this.nodeSamples[ValueUtil.asInt((Number)((Number)node.getId()))];
                        double averagePathLength = corrected ? IsolationForest.correctedAveragePathLength(nodeSample, nodeSampleCorrected) : IsolationForest.averagePathLength(nodeSample);
                        node.setScore((Object)(nodeDepth + averagePathLength));
                    }
                    return super.visit(node);
                }
            };
            visitor.applyTo((Visitable)treeModel);
            ClassDictUtil.clearContent((ClassDict)tree);
            treeModels.add(treeModel);
        }
        AbstractTransformation normalizedAnomalyScore = new AbstractTransformation(){

            public String getName(String name) {
                return "normalizedAnomalyScore";
            }

            public Expression createExpression(FieldRef fieldRef) {
                double maxSamples = IsolationForest.this.getMaxSamples();
                double averagePathLength = corrected ? IsolationForest.correctedAveragePathLength(maxSamples, nodeSampleCorrected) : IsolationForest.averagePathLength(maxSamples);
                return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)averagePathLength)});
            }
        };
        AbstractTransformation decisionFunction = new AbstractTransformation(){

            public String getName(String name) {
                return IsolationForest.this.getDecisionFunctionField();
            }

            public boolean isFinalResult() {
                return true;
            }

            public Expression createExpression(FieldRef fieldRef) {
                Number offset = IsolationForest.this.getOffset();
                return PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)(-offset.doubleValue())), PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)2.0), PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1.0), fieldRef})})});
            }
        };
        OutlierTransformation outlier = new OutlierTransformation(){

            public String getName(String name) {
                return IsolationForest.this.createFieldName("outlier", new Object[0]);
            }

            public Expression createExpression(FieldRef fieldRef) {
                Number threshold;
                String behaviour = IsolationForest.this.getBehaviour();
                if (behaviour == null) {
                    threshold = IsolationForest.this.getThreshold();
                } else if ("old".equals(behaviour)) {
                    threshold = IsolationForest.this.getThreshold();
                } else if ("new".equals(behaviour) || "deprecated".equals(behaviour)) {
                    threshold = 0.0;
                } else {
                    throw new IllegalArgumentException(behaviour);
                }
                return PMMLUtil.createApply((String)"lessOrEqual", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)threshold)});
            }
        };
        SkLearnOutlierTransformation sklearnOutlier = new SkLearnOutlierTransformation();
        Output output = ModelUtil.createPredictedOutput((String)"rawAnomalyScore", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{normalizedAnomalyScore, decisionFunction, outlier, sklearnOutlier});
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, treeModels)).setOutput(output);
        return TreeUtil.transform(this, miningModel);
    }

    public List<List<Integer>> getEstimatorsFeatures() {
        return EnsembleUtil.transformEstimatorsFeatures(this.getList("estimators_features_", HasArray.class));
    }

    public String getBehaviour() {
        return this.getOptionalString("behaviour");
    }

    public int getMaxSamples() {
        return this.getInteger("max_samples_");
    }

    public Number getOffset() {
        if (!this.containsKey("offset_")) {
            return 0.5;
        }
        return this.getNumber("offset_");
    }

    public Number getThreshold() {
        if (this.containsKey("threshold_")) {
            return this.getNumber("threshold_");
        }
        if (this.containsKey("_threshold_")) {
            return this.getNumber("_threshold_");
        }
        return 0.0;
    }

    private static double averagePathLength(double n) {
        if (n <= 1.0) {
            return 1.0;
        }
        return 2.0 * (Math.log(n) + 0.5772156649) - 2.0 * ((n - 1.0) / n);
    }

    private static double correctedAveragePathLength(double n, boolean nodeSampleCorrected) {
        if (nodeSampleCorrected) {
            if (n <= 1.0) {
                return 0.0;
            }
            if (n <= 2.0) {
                return 1.0;
            }
        } else if (n <= 1.0) {
            return 1.0;
        }
        return 2.0 * (Math.log(n - 1.0) + 0.5772156649015329) - 2.0 * ((n - 1.0) / n);
    }
}

