/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.ExpressionTranslator;
import org.jpmml.python.Scope;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class ExpressionTransformer
extends Transformer {
    public ExpressionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        Object dtype = this.getDType();
        String expr = this.getExpr();
        DataFrameScope scope = new DataFrameScope("X", features);
        Expression expression = ExpressionTranslator.translate((String)expr, (Scope)scope);
        if (dtype != null) {
            dataType = TransformerUtil.getDataType(dtype);
        } else {
            dataType = TypeUtil.getDataType((Expression)expression, (FeatureResolver)scope);
            if (dataType == null) {
                dataType = DataType.DOUBLE;
            }
        }
        OpType opType = TransformerUtil.getOpType(dataType);
        DerivedField derivedField = this.encodeDerivedField(this.createFieldName("eval", expr), opType, dataType, expression, encoder);
        return Collections.singletonList(TransformerUtil.createFeature(derivedField, encoder));
    }

    protected DerivedField encodeDerivedField(String name, OpType opType, DataType dataType, Expression expression, SkLearnEncoder encoder) {
        return encoder.createDerivedField(name, opType, dataType, expression);
    }

    public Object getDType() {
        return super.getOptionalDType("dtype", true);
    }

    public String getExpr() {
        if (this.containsKey("expr_")) {
            return this.getString("expr_");
        }
        return this.getString("expr");
    }
}

