/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArrayUtil;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.ClassDictUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Step;
import sklearn.StepUtil;

public abstract class Estimator
extends Step {
    public static final String FIELD_APPLY = "apply";
    public static final String FIELD_DECISION_FUNCTION = "decisionFunction";
    public static final String FIELD_PREDICT = "predict";
    private static final Logger logger = LoggerFactory.getLogger(Estimator.class);

    public Estimator(String module, String name) {
        super(module, name);
    }

    public abstract MiningFunction getMiningFunction();

    public abstract Model encodeModel(Schema var1);

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features_in_") && this.get("n_features_in_") != null) {
            return this.getInteger("n_features_in_");
        }
        if (this.containsKey("n_features_")) {
            return this.getInteger("n_features_");
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public boolean isSupervised() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: 
            case REGRESSION: {
                return true;
            }
            case CLUSTERING: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public Model encode(Schema schema) {
        String algorithmName;
        String pmmlName;
        this.checkLabel(schema.getLabel());
        this.checkFeatures(schema.getFeatures());
        Model model = this.encodeModel(schema);
        String modelName = model.getModelName();
        if (modelName == null && (pmmlName = this.getPMMLName()) != null) {
            model.setModelName(pmmlName);
        }
        if ((algorithmName = model.getAlgorithmName()) == null) {
            String pyClassName = this.getClassName();
            model.setAlgorithmName(pyClassName);
        }
        this.addFeatureImportances(model, schema);
        return model;
    }

    public void checkLabel(Label label) {
        boolean supervised = this.isSupervised();
        if (supervised) {
            if (label == null) {
                throw new IllegalArgumentException("Expected a label, got no label");
            }
        } else if (label != null) {
            throw new IllegalArgumentException("Expected no label, got " + label);
        }
    }

    public void checkFeatures(List<? extends Feature> features) {
        StepUtil.checkNumberOfFeatures(this, features);
    }

    public void addFeatureImportances(Model model, Schema schema) {
        List<? extends Number> featureImportances = this.getPMMLFeatureImportances();
        if (featureImportances == null) {
            featureImportances = this.getFeatureImportances();
        }
        ModelEncoder encoder = (ModelEncoder)schema.getEncoder();
        List features = schema.getFeatures();
        if (featureImportances != null) {
            ClassDictUtil.checkSize((Collection[])new Collection[]{features, featureImportances});
            for (int i = 0; i < features.size(); ++i) {
                Feature feature = (Feature)features.get(i);
                Number featureImportance = featureImportances.get(i);
                encoder.addFeatureImportance(model, feature, featureImportance);
            }
        }
    }

    public Object getOption(String key, Object defaultValue) {
        Map<String, ?> pmmlOptions = this.getPMMLOptions();
        if (pmmlOptions != null && pmmlOptions.containsKey(key)) {
            return pmmlOptions.get(key);
        }
        if (this.containsKey(key)) {
            logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"pmml_options_") + "' is not set. Falling back to the surrogate attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)key) + "'");
            return this.get(key);
        }
        return defaultValue;
    }

    public void putOption(String key, Object value) {
        this.putOptions(Collections.singletonMap(key, value));
    }

    public void putOptions(Map<String, ?> options) {
        Map<String, ?> pmmlOptions = this.getPMMLOptions();
        if (pmmlOptions == null) {
            pmmlOptions = new LinkedHashMap();
            this.setPMMLOptions(pmmlOptions);
        }
        pmmlOptions.putAll(options);
    }

    public boolean hasFeatureImportances() {
        return this.containsKey("feature_importances_") || this.containsKey("pmml_feature_importances_");
    }

    public List<? extends Number> getFeatureImportances() {
        if (!this.containsKey("feature_importances_")) {
            return null;
        }
        return this.getNumberArray("feature_importances_");
    }

    public List<? extends Number> getPMMLFeatureImportances() {
        if (!this.containsKey("pmml_feature_importances_")) {
            return null;
        }
        return this.getNumberArray("pmml_feature_importances_");
    }

    public Estimator setPMMLFeatureImportances(List<? extends Number> pmmlFeatureImportances) {
        this.put("pmml_feature_importances_", NDArrayUtil.toArray(pmmlFeatureImportances));
        return this;
    }

    public Map<String, ?> getPMMLOptions() {
        Object value = this.get("pmml_options_");
        if (value == null) {
            return null;
        }
        return this.getDict("pmml_options_");
    }

    public Estimator setPMMLOptions(Map<String, ?> pmmlOptions) {
        this.put("pmml_options_", pmmlOptions);
        return this;
    }

    public String getSkLearnVersion() {
        return this.getOptionalString("_sklearn_version");
    }
}

