/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.weight_boosting;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Regressor;
import sklearn.StepUtil;
import sklearn.ensemble.EnsembleRegressor;

public class AdaBoostRegressor
extends EnsembleRegressor {
    public AdaBoostRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<? extends Regressor> estimators = this.getEstimators();
        return StepUtil.getNumberOfFeatures(estimators);
    }

    public MiningModel encodeModel(Schema schema) {
        List<? extends Regressor> estimators = this.getEstimators();
        List<? extends Number> estimatorWeights = this.getEstimatorWeights();
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<Model> models = new ArrayList<Model>();
        for (Regressor regressor : estimators) {
            Model model = regressor.encode(segmentSchema);
            models.add(model);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.WEIGHTED_MEDIAN, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, models, estimatorWeights));
        return miningModel;
    }

    public List<? extends Number> getEstimatorWeights() {
        return this.getNumberArray("estimator_weights_");
    }
}

